/*
 * Decompiled with CFR 0.152.
 */
package org.jnetpcap.packet.structure;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jnetpcap.packet.JHeader;
import org.jnetpcap.packet.annotate.Field;
import org.jnetpcap.packet.format.JFormatter;
import org.jnetpcap.packet.structure.AnnotatedFieldMethod;
import org.jnetpcap.packet.structure.AnnotatedFieldRuntime;
import org.jnetpcap.packet.structure.AnnotatedMethodException;
import org.jnetpcap.packet.structure.HeaderDefinitionError;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotatedField {
    private final Field annotation;
    private final Class<?> declaringClass;
    private final Method method;
    private final AnnotatedFieldRuntime runtime;
    private final List<AnnotatedField> subFields = new ArrayList<AnnotatedField>();
    private String name;

    private static void checkSingature(Class<? extends JHeader> clazz, Method method) {
        if (!method.isAnnotationPresent(Field.class)) {
            throw new AnnotatedMethodException(clazz, "missing @Field annotation on field " + method.getName());
        }
    }

    public static AnnotatedField inspectEnumConstant(String string, Field field, Map<Field.Property, AnnotatedFieldMethod> map, Class<?> clazz) {
        if (!map.containsKey((Object)Field.Property.VALUE)) {
            throw new AnnotatedMethodException(clazz, "missing value getter method for field based on enum constant: " + string);
        }
        if (!map.containsKey((Object)Field.Property.LENGTH)) {
            throw new AnnotatedMethodException(clazz, "missing length getter method for field based on enum constant: " + string);
        }
        if (!map.containsKey((Object)Field.Property.OFFSET)) {
            throw new AnnotatedMethodException(clazz, "missing offset getter method for field based on enum constant: " + string);
        }
        return new AnnotatedField(string, field, map, clazz);
    }

    public static AnnotatedField inspectMethod(Class<? extends JHeader> clazz, Method method) {
        AnnotatedField.checkSingature(clazz, method);
        AnnotatedField annotatedField = new AnnotatedField(method);
        return annotatedField;
    }

    private static JFormatter.Style mapFormatToStyle(String string) {
        if (string.contains("%s[]")) {
            return JFormatter.Style.STRING_ARRAY;
        }
        if (string.contains("%s")) {
            return JFormatter.Style.STRING;
        }
        if (string.contains("%b")) {
            return JFormatter.Style.BOOLEAN;
        }
        if (string.contains("%d")) {
            return JFormatter.Style.INT_DEC;
        }
        if (string.contains("%d[]")) {
            return JFormatter.Style.INT_DEC_ARRAY;
        }
        if (string.contains("%lx")) {
            return JFormatter.Style.LONG_HEX;
        }
        if (string.contains("%x")) {
            return JFormatter.Style.INT_HEX;
        }
        if (string.contains("#x32#")) {
            return JFormatter.Style.INT_HEX;
        }
        if (string.contains("#ip4#")) {
            return JFormatter.Style.BYTE_ARRAY_IP4_ADDRESS;
        }
        if (string.contains("#ip4[]#")) {
            return JFormatter.Style.BYTE_ARRAY_ARRAY_IP4_ADDRESS;
        }
        if (string.contains("#ip6#")) {
            return JFormatter.Style.BYTE_ARRAY_IP6_ADDRESS;
        }
        if (string.contains("#mac#")) {
            return JFormatter.Style.BYTE_ARRAY_COLON_ADDRESS;
        }
        if (string.contains("#hexdump#")) {
            return JFormatter.Style.BYTE_ARRAY_HEX_DUMP;
        }
        if (string.contains("#textdump#")) {
            return JFormatter.Style.STRING_TEXT_DUMP;
        }
        if (string.contains("#bitfield#")) {
            return JFormatter.Style.INT_BITS;
        }
        if (string.contains("#timestamp#")) {
            return JFormatter.Style.TIMESTAMP;
        }
        if (string.contains("#timestamp_seconds#")) {
            return JFormatter.Style.TIMESTAMP_SECONDS;
        }
        if (string.contains("#octets#")) {
            return JFormatter.Style.BYTE_ARRAY_OCTET_STREAM;
        }
        return JFormatter.Style.STRING;
    }

    private AnnotatedField(Method method) {
        this.method = method;
        this.annotation = method.getAnnotation(Field.class);
        this.runtime = new AnnotatedFieldRuntime(this);
        this.declaringClass = method.getDeclaringClass();
    }

    public AnnotatedField(String string, Field field, Map<Field.Property, AnnotatedFieldMethod> map, Class<?> clazz) {
        this.name = string;
        this.method = map.get((Object)((Object)Field.Property.VALUE)).method;
        this.annotation = field;
        this.runtime = new AnnotatedFieldRuntime(this);
        this.declaringClass = this.method.getDeclaringClass();
        this.runtime.setFunction(map);
    }

    public void addSubField(AnnotatedField annotatedField) {
        this.subFields.add(annotatedField);
    }

    public void finishProcessing(List<HeaderDefinitionError> list) {
        this.runtime.finishProcessing(list);
        for (AnnotatedField annotatedField : this.subFields) {
            annotatedField.finishProcessing(list);
        }
    }

    public Class<?> getDeclaringClass() {
        return this.declaringClass;
    }

    public String getDescription() {
        return this.annotation.description();
    }

    public final String getDisplay() {
        return this.annotation.display().length() == 0 ? this.getName() : this.annotation.display();
    }

    public final String getFormat() {
        if (this.isSubField() && this.annotation.format().length() == 0) {
            return "#bitfield#";
        }
        return this.annotation.format().length() == 0 ? "%s" : this.annotation.format();
    }

    public int getLength() {
        return this.annotation.length();
    }

    public long getMask() {
        return this.annotation.mask();
    }

    public Method getMethod() {
        return this.method;
    }

    public final String getName() {
        if (this.name != null) {
            return this.name;
        }
        return this.annotation.name().length() == 0 ? this.method.getName() : this.annotation.name();
    }

    public final String getNicname() {
        return this.annotation.nicname().length() == 0 ? this.getName() : this.annotation.nicname();
    }

    public int getOffset() {
        return this.annotation.offset();
    }

    public String getParent() {
        return this.annotation.parent();
    }

    public JFormatter.Priority getPriority() {
        return this.annotation.priority();
    }

    public final AnnotatedFieldRuntime getRuntime() {
        return this.runtime;
    }

    public JFormatter.Style getStyle() {
        if (this.isSubField()) {
            return JFormatter.Style.INT_BITS;
        }
        return AnnotatedField.mapFormatToStyle(this.getFormat());
    }

    public List<AnnotatedField> getSubFields() {
        return this.subFields;
    }

    public String getUnits() {
        return this.annotation.units();
    }

    public boolean isSubField() {
        return this.annotation.parent().length() != 0;
    }
}

