package de.fraunhofer.sit.c2x.pki.etsi_ts103097v1114.impl;

import de.fraunhofer.sit.c2x.pki.etsi_ts103097v1114.impl.ValidityRestrictionTypeImpl.ValidityRestrictionType;
import de.fraunhofer.sit.c2x.pki.etsi_ts103097v1114.utils.BiDirectionalMap;
import de.fraunhofer.sit.c2x.pki.etsi_ts103097v1114.utils.EnumMapping;

/**
 * 
 * @author Daniel Quanz (daniel.quanz@sit.fraunhofer.de)
 * 
 */
public class ValidityRestrictionTypeImpl extends
		EnumMapping<ValidityRestrictionType> {

	public enum ValidityRestrictionType {

		TIME_END, // 0
		TIME_START_AND_END, // 1
		TIME_START_AND_DURATION, // 2
		REGION; // 3

	}

	private static ValidityRestrictionTypeImpl instance = null;

	private ValidityRestrictionTypeImpl() {
	}

	public static ValidityRestrictionTypeImpl getInstance() {
		if (instance == null)
			instance = new ValidityRestrictionTypeImpl();
		return instance;
	}

	@Override
	protected void initMapping(
			BiDirectionalMap<Integer, ValidityRestrictionType> map) {
		map.put(0, ValidityRestrictionType.TIME_END);
		map.put(1, ValidityRestrictionType.TIME_START_AND_END);
		map.put(2, ValidityRestrictionType.TIME_START_AND_DURATION);
		map.put(3, ValidityRestrictionType.REGION);
	}

}
