package de.fraunhofer.sit.c2x.pki.etsi_ts103097v1114.impl;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Arrays;

import de.fraunhofer.sit.c2x.pki.ca.utils.ByteUtils;
import de.fraunhofer.sit.c2x.pki.etsi_ts103097v1114.visitor.EtsiVisitor;

/**
 * @author Daniel Quanz (daniel.quanz@sit.fraunhofer.de)
 * 
 */
public class UInt32 extends WaveElement {

	private byte[] unsignedBytes;

	public UInt32(long val) {

		set(val);
	}

	public UInt32(DataInputStream in) throws IOException {
		this.unsignedBytes = new byte[4];
		in.readFully(unsignedBytes);
	}

	public <T> T accept(EtsiVisitor<T> visitor) {
		return visitor.visit(this);
	}

	public long get() {
		return ByteUtils.convert4ByteArrayToLong(this.unsignedBytes);
	}

	public void set(long data) {
		// 2^32-1 = 4294967295
		if (data < 0 || data > 4294967295L) {
			throw new IllegalArgumentException("Wrong input " + data
					+ "! Value shall be between 0 and 4294967295");
		}

		this.unsignedBytes = ByteUtils.convertLongTo4ByteArray(data);
	}

	@Override
	public int writeData(DataOutputStream out) throws IOException {
		out.write(this.unsignedBytes);
		return 4;
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (!super.equals(obj))
			return false;
		if (getClass() != obj.getClass())
			return false;
		UInt32 other = (UInt32) obj;
		if (!Arrays.equals(unsignedBytes, other.unsignedBytes))
			return false;
		return true;
	}
}
