package de.fraunhofer.sit.c2x.pki.etsi_ts103097v1114.impl;

import de.fraunhofer.sit.c2x.pki.etsi_ts103097v1114.impl.SubjectAttributeTypeImpl.SubjectAttributeType;
import de.fraunhofer.sit.c2x.pki.etsi_ts103097v1114.utils.BiDirectionalMap;
import de.fraunhofer.sit.c2x.pki.etsi_ts103097v1114.utils.EnumMapping;

/**
 * 
 * @author Daniel Quanz (daniel.quanz@sit.fraunhofer.de)
 * 
 */
public class SubjectAttributeTypeImpl extends EnumMapping<SubjectAttributeType> {

	public enum SubjectAttributeType {

		VERIFICATION_KEY, // 0
		ENCRYPTION_KEY, // 1
		ASSURANCE_LEVEL, // 2
		RECONSTRUCTION_VALUE, // 3
		ITS_AID_LIST, // 32
		ITS_AID_SSP_LIST, // 33
		PRIORITY_ITS_AID_LIST, // 34
		PRIORITY_SSP_LIST; // 35

	}

	private static SubjectAttributeTypeImpl instance = null;

	private SubjectAttributeTypeImpl() {
	}

	public static SubjectAttributeTypeImpl getInstance() {
		if (instance == null)
			instance = new SubjectAttributeTypeImpl();
		return instance;
	}

	@Override
	protected void initMapping(
			BiDirectionalMap<Integer, SubjectAttributeType> map) {

		map.put(0, SubjectAttributeType.VERIFICATION_KEY);
		map.put(1, SubjectAttributeType.ENCRYPTION_KEY);
		map.put(2, SubjectAttributeType.ASSURANCE_LEVEL);
		map.put(3, SubjectAttributeType.RECONSTRUCTION_VALUE);
		map.put(32, SubjectAttributeType.ITS_AID_LIST);
		map.put(33, SubjectAttributeType.ITS_AID_SSP_LIST);
		map.put(34, SubjectAttributeType.PRIORITY_ITS_AID_LIST);
		map.put(35, SubjectAttributeType.PRIORITY_SSP_LIST);
	}

}
