package de.fraunhofer.sit.c2x.pki.etsi_ts103097v1114.impl;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

import de.fraunhofer.sit.c2x.pki.etsi_ts103097v1114.serializer.Internal;
import de.fraunhofer.sit.c2x.pki.etsi_ts103097v1114.visitor.EtsiVisitor;

/**
 * 
 * @author Daniel Quanz (daniel.quanz@sit.fraunhofer.de)
 * 
 */
public class RectangularRegion extends WaveElement implements de.fraunhofer.sit.c2x.pki.ca.validator.region.interfaces.RectangularRegion {

	// ---- fields ----

	@Internal(order = 0)
	private TwoDLocation northwest;

	@Internal(order = 1)
	private TwoDLocation southeast;

	// ---- fields ----

	// ---- constructors ----

	public RectangularRegion() {
	}
	
	public RectangularRegion(TwoDLocation northWest, TwoDLocation southEast) {
		this.northwest = northWest;
		this.southeast = southEast;
	}

	public RectangularRegion(DataInputStream in) throws IOException {
		northwest = new TwoDLocation(in);
		southeast = new TwoDLocation(in);
	}

	// ---- accept ----

	public <T> T accept(EtsiVisitor<T> visitor) {
		return visitor.visit(this);
	}

	// ---- getter ----

	public TwoDLocation getNorthwest() {
		return this.northwest;
	}

	public TwoDLocation getSoutheast() {
		return this.southeast;
	}

	// ---- setter ----

	public void setNorthwest(TwoDLocation northwest) {
		this.northwest = northwest;
	}

	public void setSoutheast(TwoDLocation southeast) {
		this.southeast = southeast;
	}

	@Override
	public int writeData(DataOutputStream out) throws IOException {
		if (northwest == null || southeast == null) {
			throw new IllegalArgumentException();
		}
		int written = 0;
		written += northwest.writeData(out);
		written += southeast.writeData(out);

		return written;

	}

	@Override
	public de.fraunhofer.sit.c2x.pki.ca.validator.region.interfaces.TwoDLocation getUpperLeft() {
		return northwest;
	}

	@Override
	public de.fraunhofer.sit.c2x.pki.ca.validator.region.interfaces.TwoDLocation getLowerRight() {
		return southeast;
	}
}