/**
 * 
 */
package de.fraunhofer.sit.c2x.pki.etsi_ts103097v1114.impl;

import de.fraunhofer.sit.c2x.pki.etsi_ts103097v1114.impl.EccPointTypeImpl.EccPointType;
import de.fraunhofer.sit.c2x.pki.etsi_ts103097v1114.utils.BiDirectionalMap;
import de.fraunhofer.sit.c2x.pki.etsi_ts103097v1114.utils.EnumMapping;

/**
 * @author Daniel Quanz (daniel.quanz@sit.fraunhofer.de)
 */
public class EccPointTypeImpl extends EnumMapping<EccPointType> {

	/**
	 * @author Daniel Quanz (daniel.quanz@sit.fraunhofer.de)
	 */
	public static enum EccPointType {
		X_COORDINATE_ONLY(0), COMPRESSED_LSB_Y_0(2), COMPRESSED_LSB_Y_1(3), UNCOMPRESSED(4);

		private byte type;
		
		EccPointType(int type) {
			this.type = (byte) (0x00FF & type);
		}
		
		public byte getType() {
			return this.type;
		}
		
		public int getNumber() {
			int i = type;
			i &= 0x00FF;
			return i;
		}
	}

	private static EccPointTypeImpl instance;

	private EccPointTypeImpl() {
	}

	public static EccPointTypeImpl getInstance() {
		if (instance == null) {
			instance = new EccPointTypeImpl();
		}
		return instance;
	}

	@Override
	protected void initMapping(BiDirectionalMap<Integer, EccPointType> map) {
		map.put(0, EccPointType.X_COORDINATE_ONLY);
		map.put(2, EccPointType.COMPRESSED_LSB_Y_0);
		map.put(3, EccPointType.COMPRESSED_LSB_Y_1);
		map.put(4, EccPointType.UNCOMPRESSED);
	}

}
