/**
 * @author      ETSI / STF481 / Yann Garcia
 * @version     $URL$
 *              $Id$
 */
package org.etsi.ttcn.codec.its.security;

import org.etsi.ttcn.codec.CodecBuffer;
import org.etsi.ttcn.codec.MainCodec;
import org.etsi.ttcn.codec.generic.Record;
import org.etsi.ttcn.tci.IntegerValue;
import org.etsi.ttcn.tci.RecordValue;
import org.etsi.ttcn.tci.Type;

public class ItsAidSsp extends Record {
    
    public ItsAidSsp(MainCodec mainCodec) {
        super(mainCodec);
    }

    @Override
    protected void postEncodeField(String fieldName, CodecBuffer buf) {
//        TERFactory.getInstance().logDebug(">>> ItsAidSsp.postEncodeField: " + fieldName);
        
        if (fieldName.equals("service_specific_permissions")) {
            CodecBuffer bufLen = new CodecBuffer(new byte[] { (byte)buf.getNbBytes() } );
//            TERFactory.getInstance().logDebug("ItsAidSsp.postEncodeField: bufLen = " + bufLen);
            bufLen.append(buf);
            buf.overwriteWith(bufLen);
        }
    }
    
    @Override
    protected void preDecodeField(String fieldName, CodecBuffer buf, Type decodingHypothesis, RecordValue rv) {
//        TERFactory.getInstance().logDebug(">>> ItsAidSsp.preDecodeField: " + fieldName + ", " + decodingHypothesis.getName() + ", " + rv.getType().getName());
        
        if (fieldName.equals("service_specific_permissions")) {
            int len = buf.readBits(Byte.SIZE)[0]; // FIXME Should be IntX?
//            TERFactory.getInstance().logDebug("ItsAidSsp.preDecodeField: len=" + len);
            if (mainCodec.getHint("ServiceSpecificPermissionsContainer").equals("sspCAM")) {
                mainCodec.setHint("SspCAMLen", Integer.toString(len - 1/* Version byte*/));
            } else if (mainCodec.getHint("ServiceSpecificPermissionsContainer").equals("sspDENM")) {
                mainCodec.setHint("SspDENMLen", Integer.toString(len -1/* Version byte*/));
            } else {
                mainCodec.setHint("ServiceSpecificPermissionsContainer.opaqueLen", Integer.toString(len - 1/* Version byte*/));
            }
        }
    }
    
    @Override
    protected void postDecodeField(String fieldName, CodecBuffer buf, Type decodingHypothesis, RecordValue rv) {
//        TERFactory.getInstance().logDebug(">>> ItsAidSsp.postDecodeField: " + fieldName + ", " + decodingHypothesis.getName() + ", " + rv.getType().getName());
        
        if (fieldName.equals("its_aid")) {
            //int itsaid = ((IntegerValue)(rv.getField(fieldName))).getInt();
            int itsaid = mainCodec.getTciCDRequired().getInteger(((IntegerValue)(rv.getField(fieldName))));
            if (itsaid == 36) {
                mainCodec.setHint("ServiceSpecificPermissionsContainer", "sspCAM");
            } else if (itsaid == 37) {
                mainCodec.setHint("ServiceSpecificPermissionsContainer", "sspDENM");
            } else if (itsaid == 138) {
                mainCodec.setHint("ServiceSpecificPermissionsContainer", "opaque");
                //mainCodec.setHint("ServiceSpecificPermissionsContainer", "sspMAPEM");
            } else if (itsaid == 137) {
                mainCodec.setHint("ServiceSpecificPermissionsContainer", "opaque");
                //mainCodec.setHint("ServiceSpecificPermissionsContainer", "sspSPATEM");
            } else if (itsaid == 139) {
                mainCodec.setHint("ServiceSpecificPermissionsContainer", "opaque");
                //mainCodec.setHint("ServiceSpecificPermissionsContainer", "sspIVIM");
            } else if (itsaid == 140) {
                mainCodec.setHint("ServiceSpecificPermissionsContainer", "opaque");
                //mainCodec.setHint("ServiceSpecificPermissionsContainer", "sspSxEM");
            } else if (itsaid == 141) {
                mainCodec.setHint("ServiceSpecificPermissionsContainer", "opaque");
                //mainCodec.setHint("ServiceSpecificPermissionsContainer", "sspGnMgmt");
            } else {
                mainCodec.setHint("ServiceSpecificPermissionsContainer", "opaque");
            }
        }
    }
    
} // End of class ItsAidSsp
