/**
 * @author      ETSI / STF462 / Alexandre Berge
 * @version     $URL$
 *              $Id$
 */
package org.etsi.ttcn.codec.its.btp;

import org.etsi.ttcn.tci.TciTypeClass;
import org.etsi.ttcn.codec.CodecFactory;

public class Plugin {

    public static void init() {

        CodecFactory cf = CodecFactory.getInstance();
        cf.setCodec(TciTypeClass.RECORD, "LibItsBtp", "BtpPacket", BtpPacket.class);
        cf.setCodec(TciTypeClass.RECORD, "LibItsBtp", "BtpPayload", Payload.class);
        cf.setCodec(TciTypeClass.UNION, "LibItsBtp", "BtpHeader", BtpHeader.class);
        cf.setCodec(TciTypeClass.UNION, "LibItsBtp", "DecodedBtpPayload", DecodedBtpPayload.class);
        cf.setCodec(TciTypeClass.UNION, "LibItsBtp", "UtBtpEvent", UtBtpEvent.class);
    }
}