#include "uppertester_cam_layer_factory.hh"

#include "uppertester_types.hh"

#include "loggers.hh"

uppertester_cam_layer::uppertester_cam_layer(const std::string & p_type, const std::string & param) : t_layer<LibItsCam__TestSystem::UpperTesterPort>(p_type), _params(), _codec() {
  loggers::get_instance().log(">>> uppertester_cam_layer::uppertester_cam_layer: %s, %s", to_string().c_str(), param.c_str());
  // Setup parameters
  params::convert(_params, param);
}

void uppertester_cam_layer::sendMsg(const LibItsCam__TypesAndValues::UtCamInitialize& send_par, params& p_params){
  loggers::get_instance().log_msg(">>> uppertester_cam_layer::sendMsg", send_par);

  // Encode UpperTester PDU
  OCTETSTRING data;
  _codec.encode((const Record_Type &)send_par, data);
  // Update parameters
  send_data(data, p_params);
}

void uppertester_cam_layer::sendMsg(const LibItsCam__TypesAndValues::UtCamChangePosition& send_par, params& p_params)
{
  loggers::get_instance().log_msg(">>> uppertester_cam_layer::sendMsg", send_par);

  // Encode UpperTester PDU
  OCTETSTRING data;
  _codec.encode((const Record_Type &)send_par, data);
  // Update parameters
  send_data(data, p_params);
}

void uppertester_cam_layer::sendMsg(const LibItsCam__TypesAndValues::UtCamTrigger& send_par, params& p_params)
{
  loggers::get_instance().log_msg(">>> uppertester_cam_layer::sendMsg", send_par);

  // Encode UpperTester PDU
  OCTETSTRING data;
  _codec.encode(send_par, data);
  // Update parameters
  send_data(data, p_params);
}

void uppertester_cam_layer::send_data(OCTETSTRING& data, params& p_params) {
  loggers::get_instance().log_msg(">>> uppertester_cam_layer::send_data: ", data);
  //params.log();
  send_to_all_layers(data, p_params);
}

void uppertester_cam_layer::receive_data(OCTETSTRING& data, params& p_params)
{
  loggers::get_instance().log_msg(">>> uppertester_cam_layer::receive_data: ", data);
 
  std::unique_ptr<Base_Type> r = _codec.decode(data);
  if (r.get() != nullptr) {
    // Pass it to the ports if amy
    to_all_upper_ports(*r, p_params);
  }
}

uppertester_cam_layer_factory uppertester_cam_layer_factory::_f;
