#include "UpperTesterMapemSpatemFactory.hh"

#include "uppertester_types.hh"

#include "loggers.hh"

UpperTesterMapemSpatemLayer::UpperTesterMapemSpatemLayer(const std::string & p_type, const std::string & param) : t_layer<LibItsMapemSpatem__TestSystem::UpperTesterPort>(p_type), _params(), _codec() {
  loggers::get_instance().log(">>> UpperTesterMapemSpatemLayer::UpperTesterMapemSpatemLayer: %s, %s", to_string().c_str(), param.c_str());
  // Setup parameters
  params::convert(_params, param);
}

void UpperTesterMapemSpatemLayer::sendMsg(const LibItsMapemSpatem__TypesAndValues::UtMapemSpatemInitialize& send_par, params& p_params){
  loggers::get_instance().log_msg(">>> UpperTesterMapemSpatemLayer::sendMsg", send_par);

  // Encode UpperTester PDU
  OCTETSTRING data;
  _codec.encode((const Record_Type &)send_par, data);
  // Update parameters
  send_data(data, p_params);
}

void UpperTesterMapemSpatemLayer::sendMsg(const LibItsMapemSpatem__TypesAndValues::UtMapemSpatemTrigger& send_par, params& p_params)
{
  loggers::get_instance().log_msg(">>> UpperTesterMapemSpatemLayer::sendMsg", send_par);

  // Encode UpperTester PDU
  OCTETSTRING data;
  _codec.encode(send_par, data);
  // Update parameters
  send_data(data, p_params);
}

void UpperTesterMapemSpatemLayer::send_data(OCTETSTRING& data, params& p_params) {
  loggers::get_instance().log_msg(">>> UpperTesterMapemSpatemLayer::send_data: ", data);
  //params.log();
  send_to_all_layers(data, p_params);
}

void UpperTesterMapemSpatemLayer::receive_data(OCTETSTRING& data, params& p_params)
{
  loggers::get_instance().log_msg(">>> UpperTesterMapemSpatemLayer::receive_data: ", data);
 
  std::unique_ptr<Base_Type> r = _codec.decode(data);
  if (r.get() != nullptr) {
    // Pass it to the ports if amy
    to_all_upper_ports(*r, p_params);
  }
}

UpperTesterMapemSpatemFactory UpperTesterMapemSpatemFactory::_f;
