#ifndef UPPERTESTERMAPEMSPATEMCODEC_H
#define UPPERTESTERMAPEMSPATEMCODEC_H

#include <memory>

#include "Codec.hh"
#include "params.hh"

class Base_Type;
class Record_Type;
class TTCN_Typedescriptor_t;
class TTCN_Buffer;

namespace LibItsMapemSpatem__TypesAndValues {
  class UtMapemSpatemResults;
  class UtMapemEventInd;
  class UtSpatemEventInd;
}

class UpperTesterMapemSpatemCodec: public Codec <
  Record_Type,
  Record_Type>
{
  const unsigned char c_utMapemSpatemInitialize = 0x00;
  const unsigned char c_utMapemSpatemInitializeResult = 0x01;
  const unsigned char c_utMapemSpatemTrigger = 0xAB;
  const unsigned char c_utMapemSpatemTriggerResult = 0xAC;
  const unsigned char c_utMapemEventInd = 0xAF;
  const unsigned char c_utSpatemEventInd = 0xB0;

  int encode_ (const Base_Type& type, const TTCN_Typedescriptor_t& field_descriptor, TTCN_Buffer& encoding_buffer);

public:
  UpperTesterMapemSpatemCodec() : Codec<Record_Type, Record_Type>() { };
  virtual ~UpperTesterMapemSpatemCodec() { };

  virtual int encode (const Record_Type&, OCTETSTRING& data);
  virtual int decode (const OCTETSTRING& data, Record_Type&, params* params = NULL);
  std::unique_ptr<Base_Type> decode (const OCTETSTRING& data, params* params = NULL);
  
private:
  int decode (const OCTETSTRING& data, LibItsMapemSpatem__TypesAndValues::UtMapemSpatemResults& msg, params* params = NULL);
  int decode (const OCTETSTRING& data, LibItsMapemSpatem__TypesAndValues::UtMapemEventInd& msg, params* params = NULL);
  int decode (const OCTETSTRING& data, LibItsMapemSpatem__TypesAndValues::UtSpatemEventInd& msg, params* params = NULL);
};
#endif
