#ifndef UpperTesterIvimCODEC_H
#define UpperTesterIvimCODEC_H

#include <memory>

#include "Codec.hh"
#include "params.hh"

class Base_Type;
class Record_Type;
class TTCN_Typedescriptor_t;
class TTCN_Buffer;

namespace LibItsIvim__TypesAndValues {
  class UtIvimResults;
  class UtIvimEventInd;
}

class UpperTesterIvimCodec: public Codec <
  Record_Type,
  Record_Type>
{
  const unsigned char c_utIvimInitialize = 0x00;
  const unsigned char c_utIvimInitializeResult = 0x01;
  const unsigned char c_utIvimTrigger = 0xA4;
  const unsigned char c_utIvimTriggerResult = 0xA5;
  const unsigned char c_utIvimUpdate = 0xA6;
  const unsigned char c_utIvimUpdateResult = 0xA7;
  const unsigned char c_utIvimTermination = 0xA8;
  const unsigned char c_utIvimTerminationResult = 0xA9;
  const unsigned char c_utIvimEventInd = 0xAA;

  int encode_ (const Base_Type& type, const TTCN_Typedescriptor_t& field_descriptor, TTCN_Buffer& encoding_buffer);

public:
  UpperTesterIvimCodec() : Codec<Record_Type, Record_Type>() { };
  virtual ~UpperTesterIvimCodec() { };

  virtual int encode (const Record_Type&, OCTETSTRING& data);
  virtual int decode (const OCTETSTRING& data, Record_Type&, params* params = NULL);
  std::unique_ptr<Base_Type> decode (const OCTETSTRING& data, params* params = NULL);
  
private:
  int decode (const OCTETSTRING& data, LibItsIvim__TypesAndValues::UtIvimResults& msg, params* params = NULL);
  int decode (const OCTETSTRING& data, LibItsIvim__TypesAndValues::UtIvimEventInd& msg, params* params = NULL);
};
#endif
