#include "UpperTesterGnFactory.hh"

#include "uppertester_types.hh"

#include "loggers.hh"

UpperTesterGnLayer::UpperTesterGnLayer(const std::string & p_type, const std::string & p_param) : t_layer<LibItsGeoNetworking__TestSystem::UpperTesterPort>(p_type), _params(), _codec() {
  loggers::get_instance().log(">>> UpperTesterGnLayer::UpperTesterGnLayer: %s, %s", to_string().c_str(), p_param.c_str());
  // Setup parameters
  params::convert(_params, p_param);
  params::const_iterator it = _params.find(params::loopback);
  if (it == _params.cend()) {
    _params.insert(std::pair<std::string, std::string>(params::loopback, "0"));
  }
}

void UpperTesterGnLayer::sendMsg(const LibItsGeoNetworking__TypesAndValues::UtGnInitialize& send_par, params& p_params){
  loggers::get_instance().log_msg(">>> UpperTesterGnLayer::sendMsg", send_par);

  if (_params[params::loopback].compare("1") == 0) {
    LibItsGeoNetworking__TypesAndValues::UtGnResults ut_gn_results;
    ut_gn_results.utGnInitializeResult() = BOOLEAN(true);
    to_all_upper_ports(ut_gn_results, p_params);
  } else {
    // Encode UpperTester PDU
    OCTETSTRING data;
    _codec.encode(static_cast<const Record_Type&>(send_par), data);
    // Update parameters
    send_data(data, p_params);
  }
}

void UpperTesterGnLayer::sendMsg(const LibItsGeoNetworking__TypesAndValues::UtGnChangePosition& send_par, params& p_params)
{
  loggers::get_instance().log_msg(">>> UpperTesterGnLayer::sendMsg", send_par);

  if (_params[params::loopback].compare("1") == 0) {
    LibItsGeoNetworking__TypesAndValues::UtGnResults ut_gn_results;
    ut_gn_results.utGnChangePositionResult() = BOOLEAN(true);
    to_all_upper_ports(ut_gn_results, p_params);
  } else {
    // Encode UpperTester PDU
    OCTETSTRING data;
    _codec.encode(static_cast<const Record_Type&>(send_par), data);
    // Update parameters
    send_data(data, p_params);
  }
}

void UpperTesterGnLayer::sendMsg(const LibItsGeoNetworking__TypesAndValues::UtGnTrigger& send_par, params& p_params)
{
  loggers::get_instance().log_msg(">>> UpperTesterGnLayer::sendMsg", send_par);

  if (_params[params::loopback].compare("1") == 0) {
    LibItsGeoNetworking__TypesAndValues::UtGnResults ut_gn_results;
    ut_gn_results.utGnTriggerResult() = BOOLEAN(true);
    to_all_upper_ports(ut_gn_results, p_params);
  } else {
    // Encode UpperTester PDU
    OCTETSTRING data;
    _codec.encode((const Record_Type&)send_par, data);
    // Update parameters
    send_data(data, p_params);
  }
}

void UpperTesterGnLayer::sendMsg(const LibItsGeoNetworking__TypesAndValues::UtAutoInteropTrigger& send_par, params& p_params)
{
  loggers::get_instance().log_msg(">>> UpperTesterGnLayer::sendMsg", send_par);

  if (_params[params::loopback].compare("1") == 0) {
    LibItsGeoNetworking__TypesAndValues::UtGnResults ut_gn_results;
    ut_gn_results.utGnTriggerResult() = BOOLEAN(true);
    to_all_upper_ports(ut_gn_results, p_params);
  } else {
    // Encode UpperTester PDU
    OCTETSTRING data;
    _codec.encode((const Record_Type&)send_par, data);
    // Update parameters
   send_data(data, p_params);
  }
}

void UpperTesterGnLayer::send_data(OCTETSTRING& data, params& p_params) {
  loggers::get_instance().log_msg(">>> UpperTesterGnLayer::send_data: ", data);
  //params.log();
  send_to_all_layers(data, p_params);
}

void UpperTesterGnLayer::receive_data(OCTETSTRING& data, params& p_params)
{
  loggers::get_instance().log_msg(">>> UpperTesterGnLayer::receive_data: ", data);
  std::unique_ptr<Base_Type> r = _codec.decode(data);
  if (r.get() != nullptr) {
    // Pass it to the ports if any
    to_all_upper_ports(*r, p_params);
  }
}

UpperTesterGnFactory UpperTesterGnFactory::_f;
