#include <string>
//#include <typeinfo>

#include "UpperTesterGnCodec.hh"
#include "loggers.hh"

#include "uppertester_types.hh"

template <typename T_type> class OPTIONAL;
class TTCN_EncDec;

int UpperTesterGnCodec::encode (const Record_Type& msg, OCTETSTRING& data)
{
  loggers::get_instance().log_msg(">>> UpperTesterGnCodec::encode: ", (const Record_Type&)msg);
  
  TTCN_EncDec::clear_error();
  TTCN_Buffer encoding_buffer;
  if (std::string(msg.get_descriptor()->name).compare("@LibItsGeoNetworking_TypesAndValues.UtGnInitialize") == 0) {
    encoding_buffer.put_c(static_cast<unsigned char>(UpperTesterGnCodec::c_utGnInitialize));
  } else if (std::string(msg.get_descriptor()->name).compare("@LibItsGeoNetworking_TypesAndValues.UtGnChangePosition") == 0) {
    encoding_buffer.put_c(static_cast<unsigned char>(UpperTesterGnCodec::c_utGnChangePosition));
  } else { // Error
    data = OCTETSTRING();
    return -1;
  }
  encode_(msg, *msg.get_descriptor(), encoding_buffer);
  data = OCTETSTRING(encoding_buffer.get_len(), encoding_buffer.get_data());

  loggers::get_instance().log_msg("<<< UpperTesterGnCodec::encode: data=", data);
  return 0;
}

int UpperTesterGnCodec::encode (const Base_Type& msg, OCTETSTRING& data)
{
  loggers::get_instance().log(">>> UpperTesterGnCodec::encode: %s", msg.get_descriptor()->name);
  
  TTCN_EncDec::clear_error();
  TTCN_Buffer encoding_buffer;

  Base_Type* type = nullptr;
  if (std::string(msg.get_descriptor()->name).compare("@LibItsGeoNetworking_TypesAndValues.UtGnTrigger") == 0) {
    const LibItsGeoNetworking__TypesAndValues::UtGnTrigger& t = static_cast<const LibItsGeoNetworking__TypesAndValues::UtGnTrigger&>(msg);
    loggers::get_instance().log("UpperTesterGnCodec::encode: After cast: %s", t.get_descriptor()->name); 
    if (t.ischosen(LibItsGeoNetworking__TypesAndValues::UtGnTrigger::ALT_geoUnicast)) {
      encoding_buffer.put_c(static_cast<unsigned char>(UpperTesterGnCodec::c_utGnTrigger_GeoUnicast));
      type = (Base_Type*)&(t.geoUnicast());
    } else if (t.ischosen(LibItsGeoNetworking__TypesAndValues::UtGnTrigger::ALT_geoBroadcast)) {
      encoding_buffer.put_c(static_cast<unsigned char>(UpperTesterGnCodec::c_utGnTrigger_GeoBroadcast));
      type = (Base_Type*)&(t.geoBroadcast());
    } else if (t.ischosen(LibItsGeoNetworking__TypesAndValues::UtGnTrigger::ALT_geoAnycast)) {
      encoding_buffer.put_c(static_cast<unsigned char>(UpperTesterGnCodec::c_utGnTrigger_GeoAnycast));
      type = (Base_Type*)&(t.geoAnycast());
    } else if (t.ischosen(LibItsGeoNetworking__TypesAndValues::UtGnTrigger::ALT_shb)) {
      encoding_buffer.put_c(static_cast<unsigned char>(UpperTesterGnCodec::c_utGnTrigger_Shb));
      type = (Base_Type*)&(t.shb());
    } else if (t.ischosen(LibItsGeoNetworking__TypesAndValues::UtGnTrigger::ALT_tsb)) {
      encoding_buffer.put_c(static_cast<unsigned char>(UpperTesterGnCodec::c_utGnTrigger_Tsb));
      type = (Base_Type*)&(t.tsb());
    } // else, nothing to do
  } else {
    data = OCTETSTRING();
    return -1;
  }
  encode_(*type, *(type->get_descriptor()), encoding_buffer);
  data = OCTETSTRING(encoding_buffer.get_len(), encoding_buffer.get_data());

  loggers::get_instance().log_msg("<<< UpperTesterGnCodec::encode: data=", data);

  return 0;
}

int UpperTesterGnCodec::encode_ (const Base_Type& type, const TTCN_Typedescriptor_t& field_descriptor, TTCN_Buffer& encoding_buffer)
{
  loggers::get_instance().log(">>> UpperTesterGnCodec::encode_: processing %s/%s", type.get_descriptor()->name, field_descriptor.name);
  loggers::get_instance().log_msg(">>> UpperTesterGnCodec::encode_: ", type);
  
  if (dynamic_cast<const Record_Type*>(&type) != NULL) {
    const Record_Type& r = (const Record_Type &)type;
    loggers::get_instance().log("UpperTesterGnCodec::encode_: processing Record_Type %s", r.get_descriptor()->name);
    for(int i = 0; i < r.get_count(); i++) {
      loggers::get_instance().log("UpperTesterGnCodec::encode_: processing %s/%s/%s - %d (1 ==> use dynamic_cast<const OPTIONAL<...>) - %d", r.fld_name(i), r.fld_descr(i)->name, r.get_at(i)->get_descriptor()->name, r.get_at(i)->is_optional(), r.get_at(i)->is_present());
      if (r.get_at(i)->is_present()) {
        if (encode_(*r.get_at(i), *r.fld_descr(i), encoding_buffer) == -1) {
          loggers::get_instance().warning("UpperTesterGnCodec::encode_: -1 result code returned");
          return -1;
        }
      }
    } // End of 'for' statement
  } else {
    std::string s(field_descriptor.name);
    if (s.rfind(".shape") != string::npos) {
      encoding_buffer.put_c((unsigned char)static_cast<const Enum_Type&>(type).as_int());
    } else if (s.rfind(".payload") != string::npos) {
      const OCTETSTRING& os = static_cast<const OCTETSTRING&>(type);
      const unsigned char s[] = { (unsigned char)((os.lengthof() & 0x0000FF00) >> 8), (unsigned char)os.lengthof() };
      encoding_buffer.put_s(2, s);
      if (os.lengthof() != 0) {
        encoding_buffer.put_string(os);
      }
    } else {
      loggers::get_instance().log("UpperTesterGnCodec::encode_ (else): processing type %s/%s", type.get_descriptor()->name, field_descriptor.name);
      type.encode(field_descriptor, encoding_buffer, TTCN_EncDec::CT_RAW);
    }
  }
  
  loggers::get_instance().log_to_hexa("<<<UpperTesterGnCodec::encode_: encoding_buffer=", encoding_buffer);
  return 0;
}

int UpperTesterGnCodec::decode (const OCTETSTRING& data, Record_Type& msg, params* params)
{
  TTCN_EncDec::clear_error();
  TTCN_Buffer decoding_buffer(data);
  _params = params;
  
  loggers::get_instance().log_to_hexa(">>> UpperTesterGnCodec::decode: decoding_buffer=", decoding_buffer);
  //decode_(msg, *msg.get_descriptor(), decoding_buffer);
  
  loggers::get_instance().log_msg("<<< UpperTesterGnCodec::decode: ", (const Record_Type&)msg);
  return 0;
}

std::unique_ptr<Base_Type> UpperTesterGnCodec::decode (const OCTETSTRING& data, params* params) {

  std::unique_ptr<Base_Type> result;
  
  const unsigned char* ptr = static_cast<const unsigned char*>(data);
  if (
      (*ptr == UpperTesterGnCodec::c_utGnInitializeResult) ||
      (*ptr == UpperTesterGnCodec::c_utGnChangePositionResult) ||
      (*ptr == UpperTesterGnCodec::c_utGnTriggerResult)
      ) {
    LibItsGeoNetworking__TypesAndValues::UtGnResults res;
    decode(data, res, params);
    result.reset((Base_Type *)res.clone());
  } else {
    LibItsGeoNetworking__TypesAndValues::UtGnEventInd ind;
    decode(data, ind, params);
    result.reset((Base_Type *)ind.clone());
  }

  return result;
}

int UpperTesterGnCodec::decode (const OCTETSTRING& data, LibItsGeoNetworking__TypesAndValues::UtGnResults& msg, params* params)
{
  loggers::get_instance().log_to_hexa(">>> UpperTesterGnCodec::decode: decoding_buffer=", data);

  const unsigned char* ptr = static_cast<const unsigned char*>(data);
  if (*ptr == UpperTesterGnCodec::c_utGnInitializeResult) {
    msg.utGnInitializeResult() = BOOLEAN(*(ptr + 1) == 0x01);
  } else if (*ptr == UpperTesterGnCodec::c_utGnChangePositionResult) {
    msg.utGnChangePositionResult() = BOOLEAN(*(ptr + 1) == 0x01);
  } else if (*ptr == UpperTesterGnCodec::c_utGnTriggerResult) {
    msg.utGnTriggerResult() = BOOLEAN(*(ptr + 1) == 0x01);
  } else {
    TTCN_warning("UpperTesterGnCodec::decode: Unsupported result");
  }
  
  loggers::get_instance().log_msg("<<< UpperTesterGnCodec::decode", msg);
  return 0;
}

int UpperTesterGnCodec::decode (const OCTETSTRING& data, LibItsGeoNetworking__TypesAndValues::UtGnEventInd& msg, params* params)
{
  loggers::get_instance().log_to_hexa(">>> UpperTesterGnCodec::decode: decoding_buffer=", data);

  /*const unsigned char* ptr = static_cast<const unsigned char*>(data);
  if (*ptr == UpperTesterGnCodec::c_utDenmInitializeResult) {
    msg.utDenmInitializeResult() = BOOLEAN(*(ptr + 1) == 0x01);
  } else if (*ptr == UpperTesterGnCodec::c_utChangePositionResult) {
    msg.utChangePseudonymResult() = BOOLEAN(*(ptr + 1) == 0x01);
  } else if (*ptr == UpperTesterGnCodec::c_utDenmTriggerResult) {
    // TODO msg.utDenmTriggerResult() = BOOLEAN(*(ptr + 1) == 0x01);
  } else {
    TTCN_warning("UpperTesterGnCodec::decode: Unsupported result");
    }*/
  
  loggers::get_instance().log_msg("<<< UpperTesterGnCodec::decode", msg);
  return 0;
}
