#include "EtsiTs103097Module.hh"

#include "security_db_record.hh"

security_db_record::security_db_record(
                                       const std::string& p_certificate_id,
                                       const std::vector<unsigned char>& p_certificate,
                                       const IEEE1609dot2::CertificateBase& p_decoded_certificate,
                                       const std::vector<unsigned char>& p_hashed_id_issuer,
                                       const std::vector<unsigned char>& p_hashed_id,
                                       const std::vector<unsigned char>& p_pr_key,
                                       const std::vector<unsigned char>& p_pu_key_x,
                                       const std::vector<unsigned char>& p_pu_key_y,
                                       const std::vector<unsigned char>& p_pr_enc_key,
                                       const std::vector<unsigned char>& p_pu_enc_key_x,
                                       const std::vector<unsigned char>& p_pu_enc_key_y,
                                       const bool p_to_be_saved
                                       ): _algorithm{ec_elliptic_curves::nist_p_256}, _certificate_id(p_certificate_id), _certificate(p_certificate), _hashed_id_issuer(p_hashed_id_issuer), _hashed_id(p_hashed_id), _pr_key(p_pr_key), _pu_key_x(p_pu_key_x), _pu_key_y(p_pu_key_y), _pr_enc_key(p_pr_enc_key), _pu_enc_key_x(p_pu_enc_key_x), _pu_enc_key_y(p_pu_enc_key_y), _to_be_saved(p_to_be_saved), _decoded_certificate(static_cast<IEEE1609dot2::CertificateBase*>(p_decoded_certificate.clone())) {
}

const IEEE1609dot2::CertificateBase& security_db_record::decoded_certificate() const {
  return *_decoded_certificate;
}
