#ifndef MAPEMCODEC_H
#define MAPEMCODEC_H

#include "Codec.hh"
#include "per_codec.hh"
#include "params.hh"

#include "LibItsMapemSpatem_TestSystem.hh"

class MapemPDUCodec : public per_codec <MAPEM__PDU__Descriptions::MAPEM>
{
public:
  explicit MapemPDUCodec() { };
  virtual int encode (const MAPEM__PDU__Descriptions::MAPEM& sapem, BITSTRING& data);
  virtual int decode (const BITSTRING& data, MAPEM__PDU__Descriptions::MAPEM&);
};

class MapemCodec : public Codec<MAPEM__PDU__Descriptions::MAPEM, MAPEM__PDU__Descriptions::MAPEM>
{
  MapemPDUCodec asn_codec;

public:
  explicit MapemCodec() : Codec<MAPEM__PDU__Descriptions::MAPEM, MAPEM__PDU__Descriptions::MAPEM>(), asn_codec() { };
  virtual ~MapemCodec() { };

  virtual int encode (const MAPEM__PDU__Descriptions::MAPEM& sapem, OCTETSTRING& data);
  virtual int decode (const OCTETSTRING& data, MAPEM__PDU__Descriptions::MAPEM&, params* params = NULL);
};

#endif
