#include "LibItsMapemSpatem_TestSystem.hh"
#include "MapemCodec.hh"
#include "asn1/asn_application.h" // from asn1c
#include "loggers.hh"

int MapemCodec::encode (const MAPEM__PDU__Descriptions::MAPEM& mapem, OCTETSTRING& data)
{
  loggers::get_instance().log(">>> MapemCodec::encode");
  
  BITSTRING b;
  int rc = asn_codec.encode(mapem, b);
  if(rc){
    data = bit2oct(b);
    loggers::get_instance().log_msg("MapemCodec::encode: ", data);
  }
  return rc;
}

int MapemCodec::decode (const OCTETSTRING& data, MAPEM__PDU__Descriptions::MAPEM& mapem, params* params)
{
  loggers::get_instance().log_msg(">>> MapemCodec::decode: ", data);
  
  int rc = asn_codec.decode(oct2bit(data), mapem);
  loggers::get_instance().log("MapemCodec::decode: ASN.1 codec returned %d", rc);
  if(rc) {
    loggers::get_instance().log_msg("MapemCodec::decode: ", mapem);
  }
  return rc;
}

extern "C" {
  extern asn_TYPE_descriptor_t asn_DEF_MAPEM;
}

int MapemPDUCodec::encode (const MAPEM__PDU__Descriptions::MAPEM& p_mapem, BITSTRING& p_data)
{
  return _encode(MAPEM__PDU__Descriptions::MAPEM_descr_, asn_DEF_MAPEM, p_mapem, p_data);
}

int MapemPDUCodec::decode (const BITSTRING& p_data, MAPEM__PDU__Descriptions::MAPEM& p_mapem)
{
  return _decode(MAPEM__PDU__Descriptions::MAPEM_descr_, asn_DEF_MAPEM, p_data, p_mapem);
}
