/*!
 * \file      IVIMLayer.hh
 * \brief     Header file for ITS IVIM protocol layer.
 * \author    ETSI STF525
 * \copyright ETSI Copyright Notification
 *            No part may be reproduced except as authorized by written permission.
 *            The copyright and the foregoing restriction extend to reproduction in all media.
 *            All rights reserved.
 * \version   0.1
 */
#pragma once

#include "t_layer.hh"
#include "IVIMCodec.hh"

namespace LibItsIvim__TestSystem {
  class IvimPort;
  class IvimReq;
  class IvimInd;
}

class IVIMLayer : public t_layer<LibItsIvim__TestSystem::IvimPort> {
  params _params;
  IVIMCodec _codec;
public:
  IVIMLayer() : t_layer<LibItsIvim__TestSystem::IvimPort>(), _params(), _codec() {};
  IVIMLayer(const std::string& p_type, const std::string& param);
  virtual ~IVIMLayer() {};

  void sendMsg(const LibItsIvim__TestSystem::IvimReq&, params& params);
    
  virtual void send_data(OCTETSTRING& data, params& params);
  virtual void receive_data(OCTETSTRING& data, params& info);
}; // End of class IVIMLayer

