#ifndef IVIMCODEC_H
#define IVIMCODEC_H

#include "Codec.hh"
#include "per_codec.hh"
#include "params.hh"

#include "LibItsIvim_TestSystem.hh"
//class BITSTRING;
//class OCTETSTRING;
//class IVIM__PDU__Descriptions::IVIM;

class IVIMPDUCodec : public per_codec <IVIM__PDU__Descriptions::IVIM>
{
public:
  explicit IVIMPDUCodec() { };
  virtual int encode (const IVIM__PDU__Descriptions::IVIM& ivim, BITSTRING& data);
  virtual int decode (const BITSTRING& data, IVIM__PDU__Descriptions::IVIM&);
};

class IVIMCodec : public Codec<IVIM__PDU__Descriptions::IVIM, IVIM__PDU__Descriptions::IVIM>
{
  IVIMPDUCodec asn_codec;

public:
  explicit IVIMCodec() : Codec<IVIM__PDU__Descriptions::IVIM, IVIM__PDU__Descriptions::IVIM>(), asn_codec() { };
  virtual ~IVIMCodec() { };

  virtual int encode (const IVIM__PDU__Descriptions::IVIM& ivim, OCTETSTRING& data);
  virtual int decode (const OCTETSTRING& data, IVIM__PDU__Descriptions::IVIM&, params* params = NULL);
};

#endif
