#include "LibItsIvim_TestSystem.hh"
#include "IVIMCodec.hh"
#include "asn1/asn_application.h" // from asn1c
#include "loggers.hh"

int IVIMCodec::encode (const IVIM__PDU__Descriptions::IVIM& ivim, OCTETSTRING& data)
{
  loggers::get_instance().log(">>> IVIMCodec::encode");
  BITSTRING b;
  int rc = asn_codec.encode(ivim, b);
  loggers::get_instance().log("IVIMCodec::encode: ASN.1 codec returned %d", rc);
  if(rc){
    data = bit2oct(b);
    loggers::get_instance().log_msg("IVIMCodec::encode: ", data);
  }
  return rc;
}

int IVIMCodec::decode (const OCTETSTRING& data, IVIM__PDU__Descriptions::IVIM& ivim, params* params)
{
  loggers::get_instance().log_msg(">>> IVIMCodec::decode: ", data);
  
  int rc = asn_codec.decode(oct2bit(data), ivim);
  loggers::get_instance().log("IVIMCodec::decode: ASN.1 codec returned %d", rc);
  if(rc) {
    loggers::get_instance().log_msg("IVIMCodec::decode: ", ivim);
  }
  return rc;
}

extern "C" {
  extern asn_TYPE_descriptor_t asn_DEF_IVIM;
}

int IVIMPDUCodec::encode (const IVIM__PDU__Descriptions::IVIM& p_ivim, BITSTRING& p_data)
{
  return _encode(IVIM__PDU__Descriptions::IVIM_descr_, asn_DEF_IVIM, p_ivim, p_data);
}

int IVIMPDUCodec::decode (const BITSTRING& p_data, IVIM__PDU__Descriptions::IVIM& p_ivim)
{
  return _decode(IVIM__PDU__Descriptions::IVIM_descr_, asn_DEF_IVIM, p_data, p_ivim);
}
