/*!
 * \file      udp_layer_factory.hh
 * \brief     Header file for ITS Commsignia port protocol layer factory.
 * \author    ETSI STF525
 * \copyright ETSI Copyright Notification
 *            No part may be reproduced except as authorized by written permission.
 *            The copyright and the foregoing restriction extend to reproduction in all media.
 *            All rights reserved.
 * \version   0.1
 */
#pragma once

#include "t_layer.hh"
#include "params.hh"

class OCTETSTRING; //! Forward declaration of TITAN class

/*!
 * \class commsignia_layer
 * \brief  This class provides description of ITS Commsignia port protocol layer
 */
class commsignia_layer : public layer {
  static constexpr unsigned char LL_ADDR_LENGTH = 6;
  static constexpr unsigned char LL_ORG_CODE_LENGTH = 3;
  
  /**
   * \struct C2P packet description: Version 1, packet type: RX
   */
  typedef struct {
    unsigned char version;
    unsigned int timestamp_sec;
    unsigned int timestamp_msec;
    unsigned char primary_channel;
    unsigned char secondary_channel;
    unsigned char used_iface;
    unsigned char data_rate;
    unsigned char antenna;
    unsigned int latitude;
    unsigned int longitude;
    unsigned short speed;
    unsigned short heading;
    unsigned char rssi_ant1;
    unsigned char rssi_ant2;
    unsigned char noise_ant1;
    unsigned char noise_ant2;
    unsigned short cbr_ant1;
    unsigned short cbr_ant2;
  } __attribute__((__packed__)) c2p_recv;

  /**
   * \struct Injected data header
   */
  typedef struct {
    unsigned short frame_ctrl;
    unsigned short duration;
    unsigned char dst_addr[commsignia_layer::LL_ADDR_LENGTH];
    unsigned char src_addr[commsignia_layer::LL_ADDR_LENGTH];
    unsigned char bss_id[commsignia_layer::LL_ADDR_LENGTH];
    unsigned short fragment_seq_num;
  } __attribute__((__packed__)) c2p_802_11p_hdr;

  typedef unsigned short c2p_qos_ctrl;
  
  /**
   * \struct C2P/c2p_s_llc_hdr_t
   */
  typedef struct {
    unsigned char dsap;
    unsigned char ssap;
    unsigned char ctrl;
    unsigned char org_code[commsignia_layer::LL_ORG_CODE_LENGTH];
    unsigned short type;
  } __attribute__((__packed__)) c2p_llc_hdr;

  params _params;                       //! Layer parameters
  c2p_recv _c2p_recv;                   //! \todo
  c2p_802_11p_hdr _802_11p_hdr;         //! \todo
  c2p_llc_hdr _c2p_llc_hdr;             //! \todo
  std::vector<unsigned char> _mac_src;  //! Used to optimize filtering on source mac address in \see commsignia_layer::receive_data method
  std::vector<unsigned char> _eth_type; //! Used to optimize filtering on ethernet type in \see commsignia_layer::receive_data method
  
public:
  //! \publicsection
   /*!
    * \brief Specialised constructor
    *        Create a new instance of the commsignia_layer class
    * \param[in] p_type \todo
    * \param[in] p_param \todo
    */
  commsignia_layer(const std::string & p_type, const std::string & param);
  /*!
   * \brief Default destructor
   * \remark If \see _reconnect_on_send is set to false, the disconnection is done by the destructor
   */
  virtual ~commsignia_layer() {};

  virtual void send_data(OCTETSTRING& data, params& params);
  virtual void receive_data(OCTETSTRING& data, params& info);
}; // End of class commsignia_layer
