/**
 * 
 */
package de.fraunhofer.sit.c2x.pki.ca.validator.region.utils;

import de.fraunhofer.sit.c2x.pki.ca.validator.region.shape.DoubleVector2d;

/**
 * @author Daniel Quanz (daniel.quanz@sit.fraunhofer.de)
 * 
 */
public class PolygonPoint extends DoubleVector2d {

	private PolygonPointType type;

	public static enum PolygonPointType {
		INSIDE, OUTSIDE, BOUNDARY, INTERSECTION, ENTERING, EXIT;
	}

	/**
	 * @param x
	 * @param y
	 */
	public PolygonPoint(double x, double y, PolygonPointType type) {
		super(x, y);
		this.type = type;
	}

	/**
	 * @param x
	 * @param y
	 */
	public PolygonPoint(double x, double y) {

		this(x, y, PolygonPointType.BOUNDARY);
	}

	/**
	 * @param vector2d
	 */
	public PolygonPoint(DoubleVector2d vector2d) {
		this(vector2d, PolygonPointType.BOUNDARY);
	}

	/**
	 * @param vector2d
	 */
	public PolygonPoint(DoubleVector2d vector2d, PolygonPointType type) {
		super(vector2d.getX(), vector2d.getY());
		this.type = type;
	}

	/**
	 * @return the type
	 */
	public PolygonPointType getType() {
		return type;
	}


	/**
	 * @param entering
	 */
	public void setType(PolygonPointType type) {

		this.type = type;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see java.lang.Object#toString()
	 */
	@Override
	public String toString() {
		return "PolygonPoint [type=" + type + ", x=" + x + ", y=" + y + "]";
	}

	
	


}
