/**
 * 
 */
package de.fraunhofer.sit.c2x.pki.ca.validator.region.utils;

import de.fraunhofer.sit.c2x.pki.ca.validator.region.UTMCoordinate;
import de.fraunhofer.sit.c2x.pki.ca.validator.region.WGSCoordinate;
import de.fraunhofer.sit.c2x.pki.ca.validator.region.interfaces.TwoDLocation;
import de.fraunhofer.sit.c2x.pki.ca.validator.region.shape.DoubleVector2d;

/**
 * @author Daniel Quanz (daniel.quanz@sit.fraunhofer.de)
 * 
 */
public class Convert {
	private final static WgsToUtmConverter wgsUtmConverter = new WgsToUtmConverter();

	public static class aTwoDLocation {

		public static WGSCoordinate toWGS(TwoDLocation twoDLocation) {

			double latitude = twoDLocation.getLatitude();
			double longitude = twoDLocation.getLongitude();
			return new WGSCoordinate(latitude, longitude);
		}

		public static UTMCoordinate toUTM(TwoDLocation twoDLocation) {

			WGSCoordinate wgs = toWGS(twoDLocation);
			return wgsUtmConverter.convert(wgs);
		}

		/**
		 * @param center
		 * @return
		 */
		public static DoubleVector2d toVector(TwoDLocation twoDLocation) {
			UTMCoordinate utm = toUTM(twoDLocation);
			return utm;
		}
	}

	public static class aUTMCoordinate {

		public static WGSCoordinate toWGS(UTMCoordinate utm) {

			WGSCoordinate wgs = utm.toWGS();
			return new WGSCoordinate(round(wgs.getLatitude(), 6), round(wgs.getLongitude(), 6));
		}
	}

	public static double round(Double a, int n) {
		double b = optimizedPow(10.0, n);
		return Math.round(a * b) / b;
	}

	public static double optimizedPow(double base, int exp) {
		return StrictMath.pow(base, exp);
	}
}
