/**
 * 
 */
package de.fraunhofer.sit.c2x.pki.ca.validator.region;

import javax.inject.Inject;

import org.apache.log4j.Logger;

import de.fraunhofer.sit.c2x.pki.ca.core.logging.InjectLogger;
import de.fraunhofer.sit.c2x.pki.ca.validator.region.interfaces.RectangularRegion;
import de.fraunhofer.sit.c2x.pki.ca.validator.region.shape.Rectangle;
import de.fraunhofer.sit.c2x.pki.ca.validator.region.utils.Convert;

/**
 * @author Norbert Bimeyer (norbert.bissmeyer@sit.fraunhofer.de)
 * 
 */
public class RectangleRectangleValidator extends AbstractRectangleValidator<RectangularRegion> {

	@InjectLogger
	private Logger logger;

	@Inject
	public RectangleRectangleValidator() {
	}

	/**
	 * @param RectangularRegion
	 */
	public RectangleRectangleValidator(RectangularRegion[] rectangularRegions) {
		super(rectangularRegions);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.preserve.pki.ca.validator.Validator#validate(java.lang.Object)
	 */
	@Override
	public boolean validate(RectangularRegion regionToValidate) {

		if (regionToValidate == null)
			throw new IllegalArgumentException("Rectangular regions to validate must not be null or empty");

		UTMCoordinate ulUtm = Convert.aTwoDLocation.toUTM(regionToValidate.getUpperLeft());
		UTMCoordinate lrUtm = Convert.aTwoDLocation.toUTM(regionToValidate.getLowerRight());
		Rectangle rectToValidate = new Rectangle(ulUtm, lrUtm);

		if (ulUtm.getZone().equals(lrUtm.getZone()) == false) {
			if (logger.isWarnEnabled())
				logger.warn("North-west UTM point and south-east UTM point are not in the same zone: "
						+ ulUtm.getZone() + " != " + lrUtm.getZone());
			return false;
		}
		if (rectToValidate.getLowerRight().getX() <= rectToValidate.getUpperLeft().getX()) {
			if (logger.isWarnEnabled())
				logger.warn("South-east UTM point is west or is the same as the north-west UTM point: "
						+ rectToValidate.getLowerRight().getX() + " <= "
						+ rectToValidate.getUpperLeft().getX());
			return false;
		}
		if (rectToValidate.getLowerRight().getY() >= rectToValidate.getUpperLeft().getY()) {
			if (logger.isWarnEnabled())
				logger.warn("South-east UTM point is north or is the same as the north-west UTM point: "
						+ rectToValidate.getLowerRight().getX() + " >= "
						+ rectToValidate.getUpperLeft().getX());
			return false;
		}

		// TODO: Check whether regionToValidate is inside region of abstract
		// method

		return true;
	}
}
