package de.fraunhofer.sit.c2x.pki.ca.provider.interfaces;

import de.fraunhofer.sit.c2x.pki.ca.core.interfaces.Service;
import de.fraunhofer.sit.c2x.pki.ca.provider.ProviderException;
import de.fraunhofer.sit.c2x.pki.ca.provider.entities.AuthorizedDevice;

/**
 * @author Daniel Quanz (daniel.quanz@sit.fraunhofer.de)
 */
public interface AuthorizedDeviceProvider extends Service {

	public boolean save(AuthorizedDevice device) throws ProviderException ;
	
	public AuthorizedDevice get(byte[] canonicalId) throws ProviderException ;
	
	public AuthorizedDevice[] getAll(int offset, int limit) throws ProviderException ;

	boolean deactivateDevice(byte[] canonicalId) throws ProviderException;

	boolean reactivateDevice(byte[] canonicalId) throws ProviderException;
}
