package de.fraunhofer.sit.c2x.pki.ca.provider.entities;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;

@Entity
@Table(name = Constants.HTTP_USER__TABLE)
/**
 * @author Daniel Quanz (daniel.quanz@sit.fraunhofer.de)
 */
public class HttpUser {

	@Id
	@Column(name = Constants.HTTP_USER__COL__ID, columnDefinition = "varchar(255)", nullable = false)
	private String user;

	@Column(name = Constants.HTTP_USER__COL__PASSWORD, columnDefinition = "varchar(100)", nullable = false)
	private String password;

	@Column(name = Constants.HTTP_USER__COL__ROLE, columnDefinition = "varchar(100)", nullable = false)
	private String role;

	@Column(name = Constants.HTTP_USER__COL__ITSS_REG_ID_PREFIX, columnDefinition = "varbinary(8)", nullable = true, unique = true)
	private byte[] itsSRegPrefix;

	public HttpUser() {
	}

	public HttpUser(String user, String password, String role, byte[] itsSRegPrefix) {
		setUser(user);
		setPassword(password);
		setRole(role);
		setItsSRegPrefix(itsSRegPrefix);
	}

	public String getUser() {
		return user;
	}

	public void setUser(String user) {
		this.user = user;
	}

	public String getPassword() {
		return password;
	}

	public void setPassword(String password) {
		this.password = password;
	}

	public String getRole() {
		return role;
	}

	public void setRole(String role) {
		this.role = role;
	}

	public byte[] getItsSRegPrefix() {
		return itsSRegPrefix;
	}

	public void setItsSRegPrefix(byte[] itsSRegPrefix) {
		this.itsSRegPrefix = itsSRegPrefix;
	}
}
