package de.fraunhofer.sit.c2x.pki.ca.provider.entities;

import java.sql.Timestamp;
import java.util.Arrays;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;

import de.fraunhofer.sit.c2x.pki.ca.provider.interfaces.CreationTime;

@Entity
@Table(name = Constants.AUTHORIZED_DEVICES__TABLE)
/**
 * @author Daniel Quanz (daniel.quanz@sit.fraunhofer.de)
 */
public class AuthorizedDevice implements CreationTime {

	@Id
	@Column(name = Constants.AUTHORIZED_DEVICES__COL__ID, nullable = false, columnDefinition = "binary(16)")
	private byte[] canonicalId;

	@Column(name = Constants.AUTHORIZED_DEVICES__COL__PUBLIC_KEY, nullable = false)
	private PublicKey publicKey;

	@Column(name = Constants.AUTHORIZED_DEVICES__COL__CREATION_TIME, nullable = false)
	private Timestamp creationTime;
	
	@Column(name = Constants.AUTHORIZED_DEVICES__COL__ITS_AID_LIST, columnDefinition="blob", nullable = true)
	private byte[] itsAidList = null;
	
	@Column(name = Constants.AUTHORIZED_DEVICES__COL__ITS_AID_SSP_LIST, columnDefinition="blob", nullable = true)
	private byte[] itsAidSspList = null;
	
	@Column(name = Constants.AUTHORIZED_DEVICES__COL__PRIORITY_ITS_AID_LIST, columnDefinition="blob", nullable = true)
	private byte[] priorityItsAidList = null;
	
	@Column(name = Constants.AUTHORIZED_DEVICES__COL__PRIORITY_SSP_LIST, columnDefinition = "blob", nullable = true)
	private byte[] prioritySspList = null;
	
	@Column(name = Constants.AUTHORIZED_DEVICES__COL__SUBJECT_ASSURANCE, columnDefinition="blob", nullable = false)
	private byte[] subjectAssurance;
	
	@Column(name = Constants.AUTHORIZED_DEVICES__COL__DEACTIVATED, columnDefinition="tinyint(1) DEFAULT 0")
	private int deactivated;
	
	@Column(name = Constants.AUTHORIZED_DEVICES__COL__IDENTIFIED_REGION, columnDefinition = "blob", nullable = true)
	private byte[] idRegion = null;
	
	@Column(name = Constants.AUTHORIZED_DEVICES__COL__CIRCULAR_REGION, columnDefinition = "blob", nullable = true)
	private byte[] circularRegion = null;

	public AuthorizedDevice() {
	}

	public byte[] getCanonicalId() {
		return canonicalId;
	}

	public void setCanonicalId(byte[] canonicalId) {
		this.canonicalId = canonicalId;
	}

	public PublicKey getPublicKey() {
		return publicKey;
	}

	public void setPublicKey(PublicKey publicKey) {
		this.publicKey = publicKey;
	}

	@Override
	public void setCreationTime(Timestamp creationTime) {
		this.creationTime = creationTime;
	}

	@Override
	public Timestamp getCreationTime() {
		return creationTime;
	}

	public int getDeactivated() {
		return deactivated;
	}
	
	public boolean isDeactivated() {
		return deactivated==1;
	}

	public void setDeactivated(int deactivated) {
		this.deactivated = deactivated;
	}
	
	public void setDeactivated(boolean deactivated) {
		this.deactivated = deactivated ? 1 : 0;
	}

	public byte[] getItsAidList() {
		return itsAidList;
	}

	public void setItsAidList(byte[] itsAidList) {
		this.itsAidList = itsAidList;
	}

	public byte[] getItsAidSspList() {
		return itsAidSspList;
	}

	public void setItsAidSspList(byte[] itsAidSspList) {
		this.itsAidSspList = itsAidSspList;
	}

	public byte[] getPriorityItsAidList() {
		return priorityItsAidList;
	}

	public void setPriorityItsAidList(byte[] priorityItsAidList) {
		this.priorityItsAidList = priorityItsAidList;
	}

	public byte[] getPrioritySspList() {
		return prioritySspList;
	}

	public void setPrioritySspList(byte[] prioritySspList) {
		this.prioritySspList = prioritySspList;
	}

	public byte[] getSubjectAssurance() {
		return subjectAssurance;
	}

	public void setSubjectAssurance(byte[] subjectAssurance) {
		this.subjectAssurance = subjectAssurance;
	}
	
	public byte[] getIdRegion() {
		return idRegion;
	}

	public void setIdRegion(byte[] idRegion) {
		this.idRegion = idRegion;
	}

	public byte[] getCircularRegion() {
		return circularRegion;
	}

	public void setCircularRegion(byte[] circularRegion) {
		this.circularRegion = circularRegion;
	}

	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result + Arrays.hashCode(canonicalId);
		result = prime * result + ((creationTime == null) ? 0 : creationTime.hashCode());
		result = prime * result + deactivated;
		result = prime * result + Arrays.hashCode(itsAidList);
		result = prime * result + Arrays.hashCode(itsAidSspList);
		result = prime * result + Arrays.hashCode(priorityItsAidList);
		result = prime * result + Arrays.hashCode(prioritySspList);
		result = prime * result + ((publicKey == null) ? 0 : publicKey.hashCode());
		result = prime * result + Arrays.hashCode(subjectAssurance);
		return result;
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		AuthorizedDevice other = (AuthorizedDevice) obj;
		if (!Arrays.equals(canonicalId, other.canonicalId))
			return false;
		if (creationTime == null) {
			if (other.creationTime != null)
				return false;
		} else if (!creationTime.equals(other.creationTime))
			return false;
		if (deactivated != other.deactivated)
			return false;
		if (!Arrays.equals(itsAidList, other.itsAidList))
			return false;
		if (!Arrays.equals(itsAidSspList, other.itsAidSspList))
			return false;
		if (!Arrays.equals(priorityItsAidList, other.priorityItsAidList))
			return false;
		if (!Arrays.equals(prioritySspList, other.prioritySspList))
			return false;
		if (publicKey == null) {
			if (other.publicKey != null)
				return false;
		} else if (!publicKey.equals(other.publicKey))
			return false;
		if (!Arrays.equals(subjectAssurance, other.subjectAssurance))
			return false;
		return true;
	}
	
	

}
