package de.fraunhofer.sit.c2x.pki.ca.module.webservice.datatypes;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;

/**
 * <p>
 * Java class for geographicRegion complex type.
 * 
 * <p>
 * The following schema fragment specifies the expected content contained within
 * this class.
 * 
 * <pre>
 * &lt;complexType name="geographicRegion">
 *   &lt;complexContent>
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       &lt;sequence>
 *         &lt;element name="regionType" type="{http://www.w3.org/2001/XMLSchema}integer" maxOccurs="unbounded"/>
 *         &lt;element name="coordinates" type="{http://http.ltca.pki.c2x.sit.fraunhofer.de/}coordinates" maxOccurs="unbounded"/>
 *         &lt;element name="radius" type="{http://www.w3.org/2001/XMLSchema}integer" minOccurs="0"/>
 *       &lt;/sequence>
 *     &lt;/restriction>
 *   &lt;/complexContent>
 * &lt;/complexType>
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "geographicRegion", propOrder = { "regionType", "coordinates", "radius" })
public class GeographicRegion {

	@XmlElement(required = true)
	protected BigInteger regionType;
	@XmlElement(required = true)
	protected List<Coordinates> coordinates;
	protected BigInteger radius;

	public GeographicRegion(BigInteger latitude, BigInteger longitude, BigInteger radius, BigInteger regionType) {
		this.radius = radius;
		coordinates = new ArrayList<>();
		coordinates.add(new Coordinates(latitude, longitude));
		this.regionType = regionType;
	}

	public GeographicRegion() {
	}

	public GeographicRegion(int value) {
		regionType = new BigInteger(""+value);
	}

	/**
	 * Gets the value of the regionType property.
	 * 
	 * @return possible object is {@link BigInteger }
	 * 
	 */
	public BigInteger getRegionType() {
		return regionType;
	}

	/**
	 * Sets the value of the regionType property.
	 * 
	 * @param value
	 *            allowed object is {@link BigInteger }
	 * 
	 */
	public void setRegionType(BigInteger value) {
		this.regionType = value;
	}

	/**
	 * Gets the value of the coordinates property.
	 * 
	 * <p>
	 * This accessor method returns a reference to the live list, not a
	 * snapshot. Therefore any modification you make to the returned list will
	 * be present inside the JAXB object. This is why there is not a
	 * <CODE>set</CODE> method for the coordinates property.
	 * 
	 * <p>
	 * For example, to add a new item, do as follows:
	 * 
	 * <pre>
	 * getCoordinates().add(newItem);
	 * </pre>
	 * 
	 * 
	 * <p>
	 * Objects of the following type(s) are allowed in the list
	 * {@link Coordinates }
	 * 
	 * 
	 */
	public List<Coordinates> getCoordinates() {
		if (coordinates == null) {
			coordinates = new ArrayList<Coordinates>();
		}
		return this.coordinates;
	}

	public void setCoordinates(List<Coordinates> coordinates) {
		this.coordinates = coordinates;
	}

	/**
	 * Gets the value of the radius property.
	 * 
	 * @return possible object is {@link BigInteger }
	 * 
	 */
	public BigInteger getRadius() {
		return radius;
	}

	/**
	 * Sets the value of the radius property.
	 * 
	 * @param value
	 *            allowed object is {@link BigInteger }
	 * 
	 */
	public void setRadius(BigInteger value) {
		this.radius = value;
	}

}
