package de.fraunhofer.sit.c2x.pki.ca.module.webservice.datatypes;

import java.math.BigInteger;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;

/**
 * <p>
 * Java class for coordinates complex type.
 * 
 * <p>
 * The following schema fragment specifies the expected content contained within
 * this class.
 * 
 * <pre>
 * &lt;complexType name="coordinates">
 *   &lt;complexContent>
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       &lt;sequence>
 *         &lt;element name="latitude" type="{http://www.w3.org/2001/XMLSchema}integer"/>
 *         &lt;element name="longitude" type="{http://www.w3.org/2001/XMLSchema}integer"/>
 *       &lt;/sequence>
 *     &lt;/restriction>
 *   &lt;/complexContent>
 * &lt;/complexType>
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "coordinates", propOrder = { "latitude", "longitude" })
public class Coordinates {
	private final static double TENTHS_OF_MICRODEGREE = (10 * 1000 * 1000);

	@XmlElement(required = true)
	protected BigInteger latitude;
	@XmlElement(required = true)
	protected BigInteger longitude;

	public Coordinates(BigInteger latitude, BigInteger longitude) {
		this.latitude = latitude;
		this.longitude = longitude;
	}

	public Coordinates() {
	}

	/**
	 * Gets the value of the latitude property.
	 * 
	 * @return possible object is {@link BigInteger }
	 * 
	 */
	public BigInteger getLatitude() {
		return latitude;
	}

	public double getLatitudeDouble() {
		return latitude.doubleValue() / TENTHS_OF_MICRODEGREE;
	}

	/**
	 * Sets the value of the latitude property.
	 * 
	 * @param value
	 *            allowed object is {@link BigInteger }
	 * 
	 */
	public void setLatitude(BigInteger value) {
		this.latitude = value;
	}

	/**
	 * Gets the value of the longitude property.
	 * 
	 * @return possible object is {@link BigInteger }
	 * 
	 */
	public BigInteger getLongitude() {
		return longitude;
	}

	public double getLongitudeDouble() {
		return longitude.doubleValue() / TENTHS_OF_MICRODEGREE;
	}

	/**
	 * Sets the value of the longitude property.
	 * 
	 * @param value
	 *            allowed object is {@link BigInteger }
	 * 
	 */
	public void setLongitude(BigInteger value) {
		this.longitude = value;
	}

}
