package de.fraunhofer.sit.c2x.pki.ca.module.webservice.datatypes;

import java.util.ArrayList;
import java.util.List;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;

import de.fraunhofer.sit.c2x.pki.ca.module.webservice.datatypes.EncryptionParameters;
import de.fraunhofer.sit.c2x.pki.ca.module.webservice.datatypes.PsidSspPriority;
import de.fraunhofer.sit.c2x.pki.ca.module.webservice.datatypes.ValidityRestriction;

/**
 * <p>
 * Java class for authorizationValidationRequest complex type.
 * 
 * <p>
 * The following schema fragment specifies the expected content contained within
 * this class.
 * 
 * <pre>
 * &lt;complexType name="authorizationValidationRequest">
 *   &lt;complexContent>
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       &lt;sequence>
 *         &lt;element name="certificateFormatTypeAndVersion" type="{http://www.w3.org/2001/XMLSchema}string"/>
 *         &lt;element name="encryptedRequestSignerInfo" type="{http://www.w3.org/2001/XMLSchema}base64Binary"/>
 *         &lt;element name="encryptionParameters" type="{http://http.ltca.pki.c2x.sit.fraunhofer.de/}encryptionParameters"/>
 *         &lt;element name="numberOfPseudonyms" type="{http://www.w3.org/2001/XMLSchema}long"/>
 *         &lt;element name="psidSspPriority" type="{http://http.ltca.pki.c2x.sit.fraunhofer.de/}psidSspPriority" maxOccurs="unbounded" minOccurs="0"/>
 *         &lt;element name="recipientInfo" type="{http://http.ltca.pki.c2x.sit.fraunhofer.de/}recipientInfo"/>
 *         &lt;element name="requestHash" type="{http://www.w3.org/2001/XMLSchema}base64Binary"/>
 *         &lt;element name="requestSignature" type="{http://http.ltca.pki.c2x.sit.fraunhofer.de/}requestSignature"/>
 *         &lt;element name="validityRestriction" type="{http://http.ltca.pki.c2x.sit.fraunhofer.de/}validityRestriction"/>
 *       &lt;/sequence>
 *     &lt;/restriction>
 *   &lt;/complexContent>
 * &lt;/complexType>
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "authorizationValidationRequest", propOrder = { "certificateFormatTypeAndVersion",
		"encryptedRequestSignerInfo", "encryptionParameters", "numberOfPseudonyms", "psidSspPriority",
		"recipientInfo", "requestHash", "requestSignature", "validityRestriction" })
public class AuthorizationValidationRequest {
	//private final static long MAX_NUMBER_REQUESTED_PSEUDONYMS = 1000;

	@XmlElement(required = true)
	protected String certificateFormatTypeAndVersion;
	@XmlElement(required = true)
	protected byte[] encryptedRequestSignerInfo;
	@XmlElement(required = true)
	protected EncryptionParameters encryptionParameters;
	protected long numberOfPseudonyms;
	@XmlElement(nillable = true)
	protected List<PsidSspPriority> psidSspPriority;
	@XmlElement(required = true)
	protected RecipientInfo recipientInfo;
	@XmlElement(required = true)
	protected byte[] requestHash;
	@XmlElement(required = true)
	protected RequestSignature requestSignature;
	@XmlElement(required = true)
	protected ValidityRestriction validityRestriction;

	public AuthorizationValidationRequest() {

	}

	public AuthorizationValidationRequest(byte[] encryptedRequestSignerInfo, long numberOfPseudonyms,
			RecipientInfo recipientInfo, byte[] requestHash, RequestSignature requestSignature,
			ValidityRestriction validityRestriction, List<PsidSspPriority> psidSspPriority) {
		this.certificateFormatTypeAndVersion = "ETSI TS 103097v0.0.13";
		this.encryptedRequestSignerInfo = encryptedRequestSignerInfo;

		/* 	commented out to build invalid requests to check the correct handling
	 		of invalid requests by the AuthorizationValidationRequestHandler */
		
		// if (numberOfPseudonyms == 0)
		// throw new
		// IllegalArgumentException("Unexpected number of pseudonyms requested: "
		// + numberOfPseudonyms);
		// if (numberOfPseudonyms > MAX_NUMBER_REQUESTED_PSEUDONYMS)
		// throw new
		// IllegalArgumentException("Unexpected number of pseudonyms requested: "
		// + numberOfPseudonyms + " > " + MAX_NUMBER_REQUESTED_PSEUDONYMS);
		
		
		this.numberOfPseudonyms = numberOfPseudonyms;

		this.recipientInfo = recipientInfo;
		this.requestHash = requestHash;
		this.requestSignature = requestSignature;
		this.validityRestriction = validityRestriction;
		this.psidSspPriority = psidSspPriority;
	}

	/**
	 * Gets the value of the certificateFormatTypeAndVersion property.
	 * 
	 * @return possible object is {@link String }
	 * 
	 */
	public String getCertificateFormatTypeAndVersion() {
		return certificateFormatTypeAndVersion;
	}

	/**
	 * Sets the value of the certificateFormatTypeAndVersion property.
	 * 
	 * @param value
	 *            allowed object is {@link String }
	 * 
	 */
	public void setCertificateFormatTypeAndVersion(String value) {
		this.certificateFormatTypeAndVersion = value;
	}

	/**
	 * Gets the value of the encryptedRequestSignerInfo property.
	 * 
	 * @return possible object is byte[]
	 */
	public byte[] getEncryptedRequestSignerInfo() {
		return encryptedRequestSignerInfo;
	}

	/**
	 * Sets the value of the encryptedRequestSignerInfo property.
	 * 
	 * @param value
	 *            allowed object is byte[]
	 */
	public void setEncryptedRequestSignerInfo(byte[] value) {
		this.encryptedRequestSignerInfo = value;
	}

	/**
	 * Gets the value of the encryptionParameters property.
	 * 
	 * @return possible object is {@link EncryptionParameters }
	 * 
	 */
	public EncryptionParameters getEncryptionParameters() {
		return encryptionParameters;
	}

	/**
	 * Sets the value of the encryptionParameters property.
	 * 
	 * @param value
	 *            allowed object is {@link EncryptionParameters }
	 * 
	 */
	public void setEncryptionParameters(EncryptionParameters value) {
		this.encryptionParameters = value;
	}

	/**
	 * Gets the value of the numberOfPseudonyms property.
	 * 
	 */
	public long getNumberOfPseudonyms() {
		return numberOfPseudonyms;
	}

	/**
	 * Sets the value of the numberOfPseudonyms property.
	 * 
	 */
	public void setNumberOfPseudonyms(long value) {
		this.numberOfPseudonyms = value;
	}

	/**
	 * Gets the value of the psidSspPriority property.
	 * 
	 * <p>
	 * This accessor method returns a reference to the live list, not a
	 * snapshot. Therefore any modification you make to the returned list will
	 * be present inside the JAXB object. This is why there is not a
	 * <CODE>set</CODE> method for the psidSspPriority property.
	 * 
	 * <p>
	 * For example, to add a new item, do as follows:
	 * 
	 * <pre>
	 * getPsidSspPriority().add(newItem);
	 * </pre>
	 * 
	 * 
	 * <p>
	 * Objects of the following type(s) are allowed in the list
	 * {@link PsidSspPriority }
	 * 
	 * 
	 */
	public List<PsidSspPriority> getPsidSspPriority() {
		if (psidSspPriority == null) {
			psidSspPriority = new ArrayList<PsidSspPriority>();
		}
		return this.psidSspPriority;
	}

	/**
	 * Gets the value of the recipientInfo property.
	 * 
	 * @return possible object is {@link RecipientInfo }
	 * 
	 */
	public RecipientInfo getRecipientInfo() {
		return recipientInfo;
	}

	/**
	 * Sets the value of the recipientInfo property.
	 * 
	 * @param value
	 *            allowed object is {@link RecipientInfo }
	 * 
	 */
	public void setRecipientInfo(RecipientInfo value) {
		this.recipientInfo = value;
	}

	/**
	 * Gets the value of the requestHash property.
	 * 
	 * @return possible object is byte[]
	 */
	public byte[] getRequestHash() {
		return requestHash;
	}

	/**
	 * Sets the value of the requestHash property.
	 * 
	 * @param value
	 *            allowed object is byte[]
	 */
	public void setRequestHash(byte[] value) {
		this.requestHash = value;
	}

	/**
	 * Gets the value of the requestSignature property.
	 * 
	 * @return possible object is {@link RequestSignature }
	 * 
	 */
	public RequestSignature getRequestSignature() {
		return requestSignature;
	}

	/**
	 * Sets the value of the requestSignature property.
	 * 
	 * @param value
	 *            allowed object is {@link RequestSignature }
	 * 
	 */
	public void setRequestSignature(RequestSignature value) {
		this.requestSignature = value;
	}

	/**
	 * Gets the value of the validityRestriction property.
	 * 
	 * @return possible object is {@link ValidityRestriction }
	 * 
	 */
	public ValidityRestriction getValidityRestriction() {
		return validityRestriction;
	}

	/**
	 * Sets the value of the validityRestriction property.
	 * 
	 * @param value
	 *            allowed object is {@link ValidityRestriction }
	 * 
	 */
	public void setValidityRestriction(ValidityRestriction value) {
		this.validityRestriction = value;
	}

}
