package de.fraunhofer.sit.c2x.pki.ca.module.webserver.servlets;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.codec.binary.Hex;
import org.apache.log4j.Logger;
import org.eclipse.jetty.security.authentication.SessionAuthentication;

import com.google.inject.Inject;

import de.fraunhofer.sit.c2x.pki.ca.core.logging.InjectLogger;
import de.fraunhofer.sit.c2x.pki.ca.module.webserver.interfaces.HtmlProvider;
import de.fraunhofer.sit.c2x.pki.ca.provider.ProviderException;
import de.fraunhofer.sit.c2x.pki.ca.provider.entities.HttpUser;
import de.fraunhofer.sit.c2x.pki.ca.provider.interfaces.HttpUserProvider;

/**
 * A simple servlet that outputs the certificate content of issued certificates.
 * Following arguments are allowed per GET
 * 
 * <ul>
 * <li>CertId8 or CertId10: <b>/cacert?cert=HEX or Base64</b></li>
 * </ul>
 * 
 * @author Norbert Bissmeyer (norbert.bissmeyer@sit.fraunhofer.de)
 * 
 */
public class ShowUserServlet extends AbstractServlet {

	private static final long serialVersionUID = 1L;
	protected static final String URL = "/showUser";
	protected static final String TITLE = "Show and delete http user";
	public static final String DATE_PATTERN_LOG = "yyyy-MM-dd HH:mm:ss";

	@InjectLogger
	private Logger logger;
	private HttpUserProvider httpUserProvider;

	@Inject
	public ShowUserServlet(HtmlProvider htmlProvider, HttpUserProvider httpUserProvider) {
		super(htmlProvider);
		this.httpUserProvider = httpUserProvider;
	}

	@Override
	public String getUrl() {
		return URL;
	}

	@Override
	public String getTitle() {
		return TITLE;
	}

	@Override
	protected String contentHtml(HttpServletRequest req, HttpServletResponse resp) {
		String userInfo = "";
		StringBuilder sb = new StringBuilder();

		// delete known CA
		if (req.getParameter("deleteUser") != null && req.getParameter("deleteUser").length() > 0) {

			try {
				String userString = req.getParameter("deleteUser");

				// get user from http session
				SessionAuthentication user = (SessionAuthentication) req.getSession().getAttribute(
						SessionAuthentication.__J_AUTHENTICATED);

				logger.info("USER: User " + user.getUserIdentity().getUserPrincipal().getName().toString()
						+ " deleted http user: " + userString);

				httpUserProvider.removeUser(userString);

				userInfo = "<div id=\"ackbox\">User with email addree " + userString
						+ " removed from database</div>";

			} catch (ProviderException e) {
				userInfo = "<div id=\"errorbox\">Unable to delete user</div>";
			}
		}

		HttpUser[] users = new HttpUser[0];
		try {
			users = httpUserProvider.getAll(0, 100);
		} catch (ProviderException e) {
			logger.error("Unable to get http users from DB");
			userInfo = "<div id=\"errorbox\">Unable to get http users from DB</div>";
		}

		if (!userInfo.isEmpty()) {
			sb.append("<br/><br/>" + userInfo);
		}

		// output list
		sb.append("<table>\n");
		for (HttpUser info : users) {

			sb.append("<tr><form action=\"\" onsubmit=\"return askBeforeDelete('Do you really want delete the user: "
					+ info.getUser() + "');\" method=\"get\">\n<td style=\"width:450px;\"><ul>\n");
			sb.append("<li>Email address: " + info.getUser() + "</li>\n");
			sb.append("<li>Role: " + info.getRole() + "</li>\n");
			sb.append("<li>ITS-S registration prefix: " + Hex.encodeHexString(info.getItsSRegPrefix())
					+ "</li>\n");

			sb.append("</ul></td><td style=\"width:150px; vertical-align:middle;\"><input type=\"hidden\" name=\"deleteUser\" value=\""
					+ info.getUser()
					+ "\"/><input type=\"submit\" value=\"Delete\" /></td><td style=\"width:150px;\"></td>\n</form>\n</tr>\n");

		}
		sb.append("</table>\n");

		return sb.toString();
	}

	@Override
	public boolean isProtected() {
		return true;
	}

	@Override
	public String[] getAllowedRoles() {
		return new String[] { UserRole.ADMINISTRATOR.toString() };
	}

	@Override
	public Category getCategory() {
		return Category.SETUP;
	}
}
