package de.fraunhofer.sit.c2x.pki.ca.module.webserver.servlets;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Collections;

import javax.imageio.ImageIO;
import javax.inject.Inject;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.log4j.Logger;

import de.fraunhofer.sit.c2x.pki.ca.core.logging.InjectLogger;
import de.fraunhofer.sit.c2x.pki.ca.module.webserver.interfaces.Servlet;

/**
 * @author Daniel Quanz (daniel.quanz@sit.fraunhofer.de)
 */
public class PPEGraphicServlet extends HttpServlet implements Servlet {
	private static final long serialVersionUID = -271935106408974775L;

	public static final String URL = "/ppeImage";

	public final static int lengthFactor = 20;
	public final static int height = 20;
	public final static int leftOffset = 40;
	public final static int rightOffset = 40;
	public final static int fontHeight = 5;
	public final static int fontWidth = 6;

	@InjectLogger
	protected Logger logger;

	/**
	 * 
	 */

	@Inject
	public PPEGraphicServlet() {
	}

	@Override
	protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException,
			IOException {

		OutputStream out = resp.getOutputStream();

		/* Get Content-Type. */
		String contentType = "image/png";

		/* Set headers. */
		resp.setHeader("Content-Type", contentType);
		resp.setHeader("Cache-Control", "max-age=604800");
		resp.setCharacterEncoding("UTF-8");

		BufferedImage image;
		try {
			String[] startStr = req.getParameterValues("start");
			String[] endStr = req.getParameterValues("end");
			String[] n = req.getParameterValues("n");
			int plp = Integer.valueOf(req.getParameter("plp")).intValue();

			Long[] start = stringToIntArray(startStr);
			Long[] end = stringToIntArray(endStr);

			long min = Collections.min(Arrays.asList(start));
			long max = Collections.max(Arrays.asList(end));
			

			int imageLength = leftOffset + (((int) (max - min) / plp) * lengthFactor) + rightOffset;

			image = new BufferedImage(imageLength + 1, (start.length + 2) * height + 1,
					BufferedImage.TRANSLUCENT); // 123
			// wide,
			// tall
			// image.setRGB(255,255,255);
			Graphics2D g2d = image.createGraphics();
			for (int i = 0; i < start.length; i++) {
				g2d.setColor(new Color(212, 212, 212));

				int x = leftOffset + (int) (Long.valueOf(start[i]).longValue() - min) / plp * lengthFactor;
				int y = i * height;
				int width = (int)(end[i] - start[i]) / plp * lengthFactor;
				g2d.fillRect(x, y, width, height);
				
				int k = x;
				while(k<x+width){
					g2d.drawLine(k, 0, k, (start.length + 1) * height);
					k+=lengthFactor;
				}
				
				g2d.setColor(new Color(0, 110, 146));
				g2d.drawLine(x, y, x + width, y);
				g2d.drawLine(x, y + height, x + width, y + height);
				g2d.drawLine(x, y, x, y + height);
				g2d.drawLine(x, 0, x, (start.length + 1) * height);
				g2d.drawLine(x + width, y, x + width, y + height);
				g2d.drawString(n[i], width / 2 + x - fontWidth * n[i].length(), (i + 1) * (height)
						- fontHeight);
				g2d.drawString("# " + (i + 1), 5, (i + 1) * (height) - fontHeight);

			}
			g2d.drawLine((int) leftOffset, 0, leftOffset, (start.length + 1) * height);
			g2d.drawLine((int) imageLength - rightOffset, 0, imageLength - rightOffset, (start.length + 1)
					* height);
//			g2d.drawString(String.valueOf(new Timestamp(min*1000)), leftOffset, (start.length + 1) * height);
//			g2d.drawString(
//					String.valueOf(new Timestamp(max*1000)),
//					imageLength - rightOffset - String.valueOf(new Timestamp(max*1000)).length() * (fontWidth + 2),
//					(start.length + 1) * height);

		} catch (Exception e) {

			e.printStackTrace();
			String errorMsg = "Error while creating image. Check your syntax!";
			image = new BufferedImage(fontWidth * errorMsg.length(), 4 * fontHeight,
					BufferedImage.TRANSLUCENT);

			Graphics2D g2d = image.createGraphics();
			g2d.setColor(Color.RED);
			g2d.drawString(errorMsg, 1, 3 * fontHeight);
		}

		ImageIO.write(image, "png", out);

		/* Send response header with Content-Length. */
		resp.setStatus(200);

		out.flush();
		out.close();
	}

	public Long[] stringToIntArray(String[] str) {
		Long[] ret = new Long[str.length];
		for (int i = 0; i < ret.length; i++) {
			ret[i] = Long.valueOf(str[i]);
		}
		return ret;
	}

	@Override
	public String getUrl() {
		return URL;
	}

	@Override
	public String getTitle() {
		return "PPEImage";
	}

	@Override
	public boolean isProtected() {
		return true;
	}

	@Override
	public String[] getAllowedRoles() {
		return new String[] { UserRole.ADMINISTRATOR.toString(), UserRole.DEVELOPER.toString(),
				UserRole.MAINTAINER.toString(), UserRole.REGISTRATION_USER.toString() };
	}

	@Override
	public Category getCategory() {
		return Category.NO_CATEGORY;
	}

}
