package de.fraunhofer.sit.c2x.pki.ca.module.webserver.servlets;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.log4j.Logger;

import com.google.inject.Inject;

import de.fraunhofer.sit.c2x.pki.ca.core.logging.InjectLogger;
import de.fraunhofer.sit.c2x.pki.ca.module.webserver.interfaces.HtmlProvider;
import de.fraunhofer.sit.c2x.pki.ca.module.webserver.servlets.interfaces.IssuedCaCertificateWebHandler;
import de.fraunhofer.sit.c2x.pki.ca.provider.entities.IssuedCertificateInfo;
import de.fraunhofer.sit.c2x.pki.ca.provider.interfaces.IssuedCertsInfoProvider;

public class IssuedCaCertificatesServlet extends AbstractServlet {

	public static final String URL = "/issuedCaCertificates";
	public static final String TITLE = "Add issued CA certificates";
	// public static final String DATE_PATTERN_LOG = "yyyy-MM-dd HH:mm:ss,SSS";

	// private IssuedCertsInfoProvider<IssuedCertificateInfo>
	// issuedCertsInfoProvider;

	private String info;

	@InjectLogger
	private Logger logger;

	@Inject
	private IssuedCaCertificateWebHandler handler;

	@Inject
	public IssuedCaCertificatesServlet(HtmlProvider htmlProvider,
			IssuedCertsInfoProvider<IssuedCertificateInfo> issuedCertsInfoProvider) {
		super(htmlProvider);
	}

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	@Override
	public String getUrl() {
		return URL;
	}

	@Override
	public String getTitle() {
		return TITLE;
	}

	@Override
	protected String contentHtml(HttpServletRequest req, HttpServletResponse resp) {

		StringBuilder sb = new StringBuilder();
		info = "";
		
		if (req.getParameter("addCertificate") != null) {

			String errorInfo = "";

			if (req.getParameter("certificate") != null) {

				try {
					boolean result = handler.handleIssuedCaCertificateString(req.getParameter("certificate"));
					if (result != true)
						throw new Exception("Handler error");
				} catch (Exception e) {
					logger.error("Unable to insert CA certificate into DB: " + e.getMessage());
					errorInfo = "Unable to insert CA certificate into DB: " + e.getMessage();
				}

			}

			if (errorInfo.isEmpty()) {
				sb.append("<div id=\"ackbox\">CA certificate inserted into DB</div>");
			} else {
				sb.append("<div id=\"errorbox\">" + errorInfo + "</div>");
			}
		}else{
			sb.append("<form action=\"" + URL + "\" method=\"get\">\n");
			if (!info.isEmpty())
				sb.append(info);
			sb.append("Please enter the new CA certificate.\n");
			sb.append("<table>\n");
			sb.append("<tr><td>Certificate (hex-encoded):</td><td><textarea id=\"certificate\" name=\"certificate\" rows=\"5\" style=\"width:400px\"></textarea></td></tr>\n");
			sb.append("<tr><td></td><td><input type=\"submit\" name=\"addCertificate\" value=\"Submit\" /></td></tr>\n");
			sb.append("</table>\n" + "</form>\n");
		}

		return sb.toString();
	}

	@Override
	public boolean isProtected() {
		return true;
	}

	@Override
	public String[] getAllowedRoles() {
		return new String[] { UserRole.ADMINISTRATOR.toString() };
	}

	@Override
	public Category getCategory() {
		return Category.SETUP;
	}
}
