package de.fraunhofer.sit.c2x.pki.ca.module.webserver;

import java.io.IOException;

import javax.inject.Inject;

import org.apache.log4j.Logger;
import org.eclipse.jetty.security.MappedLoginService;
import org.eclipse.jetty.server.UserIdentity;
import org.eclipse.jetty.util.security.Password;

import de.fraunhofer.sit.c2x.pki.ca.core.logging.InjectLogger;
import de.fraunhofer.sit.c2x.pki.ca.provider.entities.HttpUser;
import de.fraunhofer.sit.c2x.pki.ca.provider.interfaces.HttpUserProvider;

public class DBLoginService extends MappedLoginService {

	@Inject
	private HttpUserProvider httpUserProvider;

	@InjectLogger
	Logger logger;

	@Inject
	public DBLoginService() {
		setName("DB Login Name");
	}

	@Override
	protected UserIdentity loadUser(String username) {

		HttpUser user = httpUserProvider.getUser(username);
		if (user != null) {
			return putUser(user.getUser(), new Password(user.getPassword()), new String[] { user.getRole() });
		}
		return null;
	}

	@Override
	public UserIdentity login(String username, Object credentials) {
		UserIdentity ui = super.login(username, credentials);
		if (logger.isInfoEnabled())
			logger.info("USER: User " + username + " tries to log in!");

		return ui;
	};

	@Override
	public void logout(UserIdentity identity) {

		if (logger.isInfoEnabled())
			logger.info("USER: User " + identity.getUserPrincipal().getName().toString() + " tries to log out!");

		super.logout(identity);
	};

	@Override
	protected void loadUsers() throws IOException {

	}

}
