/**
 * 
 */
package de.fraunhofer.sit.c2x.pki.ca.measuring;

/**
 * @author Norbert Bimeyer (norbert.bissmeyer@sit.fraunhofer.de)
 * 
 */
public enum MeasuringKey {
	ITS_S_REGISTRATION_PERMISSION_CHECKS, ITS_S_REGISTRATION_STORAGE, ITS_S_REGISTRATION_PROCESSING, LTC_REQUEST_SIGNATURE_VERIFICATION, LTC_REQUEST_PERMISSION_CHECKS, LTC_GENERATION, LTC_REQUEST_PROCESSING, LTC_ACKNOWLEGMENT_PROCESSING, PC_AUTHORIZATION_SIGNER_DECRYPTION, PC_AUTHORIZATION_SIGNATURE_VERIFICATION, PC_AUTHORIZATION_PERMISSION_CHECKS, PC_AUTHORIZATION_PERMISSION_TIME_CHECKS, PC_AUTHORIZATION_PERMISSION_REGION_CHECKS, PC_AUTHORIZATION_PERMISSION_SUBJECT_ATT_CHECKS, PC_AUTHORIZATION_PERMISSION_TIME_SLOT_RESERVATION, PC_AUTHORIZATION_RESPONSE_GENERATION, PC_AUTHORIZATION_PROCESSING, PC_AUTHORIZATION_ACKNOWLEGMENT_PROCESSING, PC_REQUEST_PROCESSING, PC_SIGNATURE_GENERATION_PROCESSING, PC_RESPONSE_ACKNOWLEGMENT_PROCESSING, CA_CERTIFICATE_DOWNLOAD, CRL_DOWNLOAD, CA_CONFIGURATION_REQUEST_PROCESSING, PC_AUTHORIZATION_SIGNATURE_GENERATION, CRL_REQUEST_PROCESSING;

	public static MeasuringKey[] getAll() {
		return new MeasuringKey[] { MeasuringKey.ITS_S_REGISTRATION_PERMISSION_CHECKS,
				MeasuringKey.ITS_S_REGISTRATION_STORAGE, MeasuringKey.ITS_S_REGISTRATION_PROCESSING,

				MeasuringKey.LTC_ACKNOWLEGMENT_PROCESSING, MeasuringKey.LTC_REQUEST_SIGNATURE_VERIFICATION,
				MeasuringKey.LTC_REQUEST_PERMISSION_CHECKS, MeasuringKey.LTC_GENERATION,
				MeasuringKey.LTC_REQUEST_PROCESSING,

				MeasuringKey.PC_AUTHORIZATION_SIGNER_DECRYPTION,
				MeasuringKey.PC_AUTHORIZATION_SIGNATURE_VERIFICATION,
				MeasuringKey.PC_AUTHORIZATION_PERMISSION_CHECKS,
				MeasuringKey.PC_AUTHORIZATION_PERMISSION_TIME_CHECKS,
				MeasuringKey.PC_AUTHORIZATION_PERMISSION_REGION_CHECKS,
				MeasuringKey.PC_AUTHORIZATION_PERMISSION_SUBJECT_ATT_CHECKS,
				MeasuringKey.PC_AUTHORIZATION_PERMISSION_TIME_SLOT_RESERVATION,
				MeasuringKey.PC_AUTHORIZATION_RESPONSE_GENERATION, MeasuringKey.PC_AUTHORIZATION_PROCESSING,
				MeasuringKey.PC_AUTHORIZATION_ACKNOWLEGMENT_PROCESSING,
				MeasuringKey.PC_AUTHORIZATION_SIGNATURE_GENERATION,

				MeasuringKey.PC_REQUEST_PROCESSING, MeasuringKey.PC_SIGNATURE_GENERATION_PROCESSING,
				MeasuringKey.PC_RESPONSE_ACKNOWLEGMENT_PROCESSING,

				MeasuringKey.CA_CERTIFICATE_DOWNLOAD,

				MeasuringKey.CRL_DOWNLOAD, MeasuringKey.CRL_REQUEST_PROCESSING,

				MeasuringKey.CA_CONFIGURATION_REQUEST_PROCESSING };
	}

	public static String getTaskName(String name) {
		name = name.replace("REQUEST", "REQ.");
		name = name.replace("RESPONSE", "RESP.");
		name = name.replace("RESPONSE", "RESP.");
		name = name.replace("REPORT", "REP.");
		name = name.replace("TRANSPORT", "TRANS.");
		name = name.replace("ENCRYPTION", "ENC.");
		name = name.replaceAll("GENERATION", "GEN.");
		name = name.replaceAll("ACKNOWLEGMENT", "ACK.");
		name = name.replaceAll("CERTIFICATE", "CERT.");
		name = name.replaceAll("PSEUDONYM", "PSEU.");
		name = name.replaceAll("RESOLUTION", "RESO.");
		name = name.replaceAll("PROCESSING", "PROC.");

		return name.replace('_', ' ').toLowerCase();
	}

	public static String getGroup(String name) {
		if (name.contains("ITS_S_"))
			return "ITS-S";
		if (name.contains("PC_"))
			return "PC";
		if (name.contains("LTC_"))
			return "LTC";
		else
			return "CA";
	}
}
