/**
 * 
 */
package de.fraunhofer.sit.c2x.pki.ca.crypto.encryption;

import java.util.Arrays;

/**
 * @author Daniel Quanz (daniel.quanz@sit.fraunhofer.de)
 * 
 */
public class ECIESCipher {

	@Override
	public String toString() {
		return "ECIESCipher [c=" + Arrays.toString(c) + ", t="
				+ Arrays.toString(t) + "]";
	}

	private static final int CIPHER_LENGTH = 16;
	private static final int TAG_LENGTH = 20;
	private static final int COMPLETE_CIPHER_LENGTH = CIPHER_LENGTH
			+ TAG_LENGTH;
	private final byte[] c;
	private final byte[] t;

	/**
	 * @throws CryptoUtilsException
	 * 
	 */
	public ECIESCipher(byte[] cipherBytes) {
		c = new byte[CIPHER_LENGTH];
		t = new byte[TAG_LENGTH];
		System.arraycopy(cipherBytes, 0, c, 0, c.length);
		System.arraycopy(cipherBytes, c.length, t, 0, t.length);
	}
	
	public ECIESCipher(byte[] c, byte[] t) {
//		if(c.length != CIPHER_LENGTH)
//			throw new IOException("cipher has illegal length");
		this.c = c;
//		if(t.length != TAG_LENGTH)
//			throw new IOException("tag has illegal length");
		this.t = t;
	}

	public byte[] getCBytes() {
		return c;
	}

	public byte[] getTBytes() {
		return t;
	}

	public byte[] getBytes() {
		byte[] cipher = new byte[COMPLETE_CIPHER_LENGTH];
		System.arraycopy(c, 0, cipher, 0, c.length);
		System.arraycopy(t, 0, cipher, c.length, t.length);
		return cipher;
	}
}
