/**
 * 
 */
package de.fraunhofer.sit.c2x.pki.ca.crypto.encryption;

import org.bouncycastle.crypto.CryptoException;
import org.bouncycastle.crypto.InvalidCipherTextException;
import org.bouncycastle.crypto.engines.AESFastEngine;
import org.bouncycastle.crypto.modes.CCMBlockCipher;
import org.bouncycastle.crypto.params.CCMParameters;
import org.bouncycastle.crypto.params.KeyParameter;

import de.fraunhofer.sit.c2x.pki.ca.crypto.interfaces.IEncryption;

/**
 * @author Daniel Quanz (daniel.quanz@sit.fraunhofer.de)
 * 
 */
public class AESwithCCM implements IEncryption {

	private byte[] nonce;
	private byte[] key;
	private int tLen;
	private byte[] associatedText;

	public void init(byte[] key, byte[] nonce) {
		init(key, nonce, new byte[0], 128);
	}

	public void init(byte[] key, byte[] nonce, byte[] associatedText, int tLen) {
		this.key = key;
		this.nonce = nonce;
		this.associatedText = associatedText;
		this.tLen = tLen;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see preserve.pki.ca.crypto.IEncryption#encrypt(byte[])
	 */
	@Override
	public byte[] encrypt(byte[] messageToEncrypt) throws CryptoException {
		if (key == null || nonce == null) {
			throw new CryptoException("Encryption is not initialized!");
		}
		// if (key.length != 16) {
		// throw new CryptoException("Key length has to be 16, but is " +
		// key.length + "!");
		// }
		// if (nonce.length > 16) {
		// throw new CryptoException("Nonce length shall be at most 16, but is "
		// + nonce.length + "!");
		// }
		return aes128Ccm(true, key, tLen, nonce, associatedText, messageToEncrypt);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see preserve.pki.ca.crypto.IEncryption#decrypt(byte[])
	 */
	@Override
	public byte[] decrypt(byte[] cipherToDecrypt) throws CryptoException {
		if (key == null || nonce == null) {
			throw new CryptoException("Decryption is not initialized!");
		}
		if(cipherToDecrypt.length<tLen/8) {
			throw new CryptoException(String.format("The length of the cipher is invalid. The length ist at least %d, but is %d", tLen/8, cipherToDecrypt.length));
		}
		return aes128Ccm(false, key, tLen, nonce, associatedText, cipherToDecrypt);
	}

	/**
	 * @param K
	 *            Key for block cipher
	 * @param Tlen
	 *            length of MAC
	 * @param N
	 *            nonce
	 * @param A
	 *            associatedText
	 * @param msg
	 *            msg
	 * 
	 * @return
	 */
	private static byte[] aes128Ccm(boolean forEncryption, byte[] K, int Tlen, byte[] N, byte[] A, byte[] msg) {

		CCMBlockCipher cipher = new CCMBlockCipher(new AESFastEngine());
		cipher.init(forEncryption, new CCMParameters(new KeyParameter(K), Tlen, N, A));

		// length of payload
		int msgLen = msg.length;
		byte[] C = (forEncryption) ? new byte[msgLen + Tlen / 8] : new byte[msgLen - Tlen / 8];
		cipher.processBytes(msg, 0, msgLen, null, 0);
		try {
			cipher.doFinal(C, 0);
			return C;
		} catch (IllegalStateException e) {
			e.printStackTrace();
		} catch (InvalidCipherTextException e) {
			e.printStackTrace();
		}
		return new byte[0];
	}

}
