package de.fraunhofer.sit.c2x.pki.ca.certificates;

import org.bouncycastle.crypto.AsymmetricCipherKeyPair;

import de.fraunhofer.sit.c2x.pki.ca.provider.interfaces.Certificate;

public class RootCertificateResult {
	
	private Certificate cert;
	
	private AsymmetricCipherKeyPair signingKeyPair;
	
	private AsymmetricCipherKeyPair encryptionKeyPair;
	
	public RootCertificateResult(Certificate cert, AsymmetricCipherKeyPair signingKeyPair, AsymmetricCipherKeyPair encryptionKeyPair) {
		this.cert = cert;
		this.signingKeyPair = signingKeyPair;
		this.encryptionKeyPair = encryptionKeyPair;
	}

	public Certificate getCert() {
		return cert;
	}

	public AsymmetricCipherKeyPair getSigningKeyPair() {
		return signingKeyPair;
	}

	public AsymmetricCipherKeyPair getEncryptionKeyPair() {
		return encryptionKeyPair;
	}
	
	

}
