/*************************************************************/
/* Copyright (C) 2015 OSS Nokalva, Inc.  All rights reserved.*/
/*************************************************************/

/* THIS FILE IS PROPRIETARY MATERIAL OF OSS NOKALVA, INC.
 * AND MAY BE USED ONLY BY DIRECT LICENSEES OF OSS NOKALVA, INC.
 * THIS FILE MAY NOT BE DISTRIBUTED. */

/* Generated for: Testing Technologies IST GmbH, Berlin, Germany - License 11335 on Linux */
/* Abstract syntax: dsrc_reg_d */
/* ASN.1 Java project: org.etsi.its.codec.tool.testingtech.LibItsMapSpat_asn1.Libitsmapspat_asn1 */
/* Created: Mon Feb  9 16:50:07 2015 */
/* ASN.1 Compiler for Java version: 5.1.0.2 */
/* ASN.1 compiler options and file names specified:
 * -output org.etsi.its.codec.tool.testingtech.LibItsMapSpat_asn1
 * -nolistingfile -nomodlistingfile -constraints -nouserconstraints -valuerefs
 * -debug -nopedantic -noinformatorymessages -uper -root -keepnames
 * -norelaySafe -noparamtypesuperclass -jiaapi -autoencdec -messageFormat emacs
 * /tmp/TTthree-2015.02.09.16.49.37.896/oss6894826343771225846gen/LibItsMapSpat_asn1.gen
 * asn/ITS-Container.asn asn/REG_D.asn asn/MAP_SPAT_ETSI.asn
 * asn/DSRC_REG_D.asn
 */


package org.etsi.its.codec.tool.testingtech.LibItsMapSpat_asn1.dsrc;

import com.oss.asn1.*;
import com.oss.metadata.*;

/**
 * Define the ASN1 Type LaneDataAttribute from ASN1 Module DSRC.
 * @see Choice
 */

public class LaneDataAttribute extends Choice {
    
    /**
     * The default constructor.
     */
    public LaneDataAttribute()
    {
    }
    
    public static final  int  pathEndPointAngle_chosen = 1;
    public static final  int  laneCrownPointCenter_chosen = 2;
    public static final  int  laneCrownPointLeft_chosen = 3;
    public static final  int  laneCrownPointRight_chosen = 4;
    public static final  int  laneAngle_chosen = 5;
    public static final  int  speedLimits_chosen = 6;
    public static final  int  regional_chosen = 7;
    
    // Methods for field "pathEndPointAngle"
    public static LaneDataAttribute createLaneDataAttributeWithPathEndPointAngle(long pathEndPointAngle)
    {
	return createLaneDataAttributeWithPathEndPointAngle(new DeltaAngle(pathEndPointAngle));
    }
    
    public static LaneDataAttribute createLaneDataAttributeWithPathEndPointAngle(DeltaAngle pathEndPointAngle)
    {
	LaneDataAttribute __object = new LaneDataAttribute();

	__object.setPathEndPointAngle(pathEndPointAngle);
	return __object;
    }
    
    public boolean hasPathEndPointAngle()
    {
	return getChosenFlag() == pathEndPointAngle_chosen;
    }
    
    public void setPathEndPointAngle(long pathEndPointAngle)
    {
	setPathEndPointAngle(new DeltaAngle(pathEndPointAngle));
    }
    
    public void setPathEndPointAngle(DeltaAngle pathEndPointAngle)
    {
	setChosenValue(pathEndPointAngle);
	setChosenFlag(pathEndPointAngle_chosen);
    }
    
    
    // Methods for field "laneCrownPointCenter"
    public static LaneDataAttribute createLaneDataAttributeWithLaneCrownPointCenter(long laneCrownPointCenter)
    {
	return createLaneDataAttributeWithLaneCrownPointCenter(new RoadwayCrownAngle(laneCrownPointCenter));
    }
    
    public static LaneDataAttribute createLaneDataAttributeWithLaneCrownPointCenter(RoadwayCrownAngle laneCrownPointCenter)
    {
	LaneDataAttribute __object = new LaneDataAttribute();

	__object.setLaneCrownPointCenter(laneCrownPointCenter);
	return __object;
    }
    
    public boolean hasLaneCrownPointCenter()
    {
	return getChosenFlag() == laneCrownPointCenter_chosen;
    }
    
    public void setLaneCrownPointCenter(long laneCrownPointCenter)
    {
	setLaneCrownPointCenter(new RoadwayCrownAngle(laneCrownPointCenter));
    }
    
    public void setLaneCrownPointCenter(RoadwayCrownAngle laneCrownPointCenter)
    {
	setChosenValue(laneCrownPointCenter);
	setChosenFlag(laneCrownPointCenter_chosen);
    }
    
    
    // Methods for field "laneCrownPointLeft"
    public static LaneDataAttribute createLaneDataAttributeWithLaneCrownPointLeft(long laneCrownPointLeft)
    {
	return createLaneDataAttributeWithLaneCrownPointLeft(new RoadwayCrownAngle(laneCrownPointLeft));
    }
    
    public static LaneDataAttribute createLaneDataAttributeWithLaneCrownPointLeft(RoadwayCrownAngle laneCrownPointLeft)
    {
	LaneDataAttribute __object = new LaneDataAttribute();

	__object.setLaneCrownPointLeft(laneCrownPointLeft);
	return __object;
    }
    
    public boolean hasLaneCrownPointLeft()
    {
	return getChosenFlag() == laneCrownPointLeft_chosen;
    }
    
    public void setLaneCrownPointLeft(long laneCrownPointLeft)
    {
	setLaneCrownPointLeft(new RoadwayCrownAngle(laneCrownPointLeft));
    }
    
    public void setLaneCrownPointLeft(RoadwayCrownAngle laneCrownPointLeft)
    {
	setChosenValue(laneCrownPointLeft);
	setChosenFlag(laneCrownPointLeft_chosen);
    }
    
    
    // Methods for field "laneCrownPointRight"
    public static LaneDataAttribute createLaneDataAttributeWithLaneCrownPointRight(long laneCrownPointRight)
    {
	return createLaneDataAttributeWithLaneCrownPointRight(new RoadwayCrownAngle(laneCrownPointRight));
    }
    
    public static LaneDataAttribute createLaneDataAttributeWithLaneCrownPointRight(RoadwayCrownAngle laneCrownPointRight)
    {
	LaneDataAttribute __object = new LaneDataAttribute();

	__object.setLaneCrownPointRight(laneCrownPointRight);
	return __object;
    }
    
    public boolean hasLaneCrownPointRight()
    {
	return getChosenFlag() == laneCrownPointRight_chosen;
    }
    
    public void setLaneCrownPointRight(long laneCrownPointRight)
    {
	setLaneCrownPointRight(new RoadwayCrownAngle(laneCrownPointRight));
    }
    
    public void setLaneCrownPointRight(RoadwayCrownAngle laneCrownPointRight)
    {
	setChosenValue(laneCrownPointRight);
	setChosenFlag(laneCrownPointRight_chosen);
    }
    
    
    // Methods for field "laneAngle"
    public static LaneDataAttribute createLaneDataAttributeWithLaneAngle(long laneAngle)
    {
	return createLaneDataAttributeWithLaneAngle(new MergeDivergeNodeAngle(laneAngle));
    }
    
    public static LaneDataAttribute createLaneDataAttributeWithLaneAngle(MergeDivergeNodeAngle laneAngle)
    {
	LaneDataAttribute __object = new LaneDataAttribute();

	__object.setLaneAngle(laneAngle);
	return __object;
    }
    
    public boolean hasLaneAngle()
    {
	return getChosenFlag() == laneAngle_chosen;
    }
    
    public void setLaneAngle(long laneAngle)
    {
	setLaneAngle(new MergeDivergeNodeAngle(laneAngle));
    }
    
    public void setLaneAngle(MergeDivergeNodeAngle laneAngle)
    {
	setChosenValue(laneAngle);
	setChosenFlag(laneAngle_chosen);
    }
    
    
    // Methods for field "speedLimits"
    public static LaneDataAttribute createLaneDataAttributeWithSpeedLimits(SpeedLimitList speedLimits)
    {
	LaneDataAttribute __object = new LaneDataAttribute();

	__object.setSpeedLimits(speedLimits);
	return __object;
    }
    
    public boolean hasSpeedLimits()
    {
	return getChosenFlag() == speedLimits_chosen;
    }
    
    public void setSpeedLimits(SpeedLimitList speedLimits)
    {
	setChosenValue(speedLimits);
	setChosenFlag(speedLimits_chosen);
    }
    
    
    // Methods for field "regional"
    public static LaneDataAttribute createLaneDataAttributeWithRegional(RegionalLaneDataAttribute regional)
    {
	LaneDataAttribute __object = new LaneDataAttribute();

	__object.setRegional(regional);
	return __object;
    }
    
    public boolean hasRegional()
    {
	return getChosenFlag() == regional_chosen;
    }
    
    public void setRegional(RegionalLaneDataAttribute regional)
    {
	setChosenValue(regional);
	setChosenFlag(regional_chosen);
    }
    
    
    // Method to create a specific choice instance
    public AbstractData createInstance(int chosen)
    {
	switch (chosen) {
	    case pathEndPointAngle_chosen:
		return new DeltaAngle();
	    case laneCrownPointCenter_chosen:
		return new RoadwayCrownAngle();
	    case laneCrownPointLeft_chosen:
		return new RoadwayCrownAngle();
	    case laneCrownPointRight_chosen:
		return new RoadwayCrownAngle();
	    case laneAngle_chosen:
		return new MergeDivergeNodeAngle();
	    case speedLimits_chosen:
		return new SpeedLimitList();
	    case regional_chosen:
		return new RegionalLaneDataAttribute();
	    default:
		throw new InternalError("Choice.createInstance()");
	}
	
    }
    
    /**
     * Initialize the type descriptor.
     */
    private static final ChoiceInfo c_typeinfo = new ChoiceInfo (
	new Tags (
	    null
	),
	new QName (
	    "org.etsi.its.codec.tool.testingtech.LibItsMapSpat_asn1.dsrc",
	    "LaneDataAttribute"
	),
	new QName (
	    "DSRC",
	    "LaneDataAttribute"
	),
	12318,
	null,
	new Fields (
	    new FieldInfo[] {
		new FieldInfo (
		    new TypeInfoRef (
			new IntegerInfo (
			    new Tags (
				new short[] {
				    (short)0x8000
				}
			    ),
			    new QName (
				"org.etsi.its.codec.tool.testingtech.LibItsMapSpat_asn1.dsrc",
				"DeltaAngle"
			    ),
			    new QName (
				"DSRC",
				"DeltaAngle"
			    ),
			    12314,
			    new ValueRangeConstraint (
				new AbstractBounds(
				    new DeltaAngle(-150), 
				    new DeltaAngle(150),
				    0
				)
			    ),
			    new Bounds (
				new java.lang.Long(-150),
				new java.lang.Long(150)
			    ),
			    null
			)
		    ),
		    "pathEndPointAngle",
		    0,
		    2
		),
		new FieldInfo (
		    new TypeInfoRef (
			new IntegerInfo (
			    new Tags (
				new short[] {
				    (short)0x8001
				}
			    ),
			    new QName (
				"org.etsi.its.codec.tool.testingtech.LibItsMapSpat_asn1.dsrc",
				"RoadwayCrownAngle"
			    ),
			    new QName (
				"DSRC",
				"RoadwayCrownAngle"
			    ),
			    12314,
			    new ValueRangeConstraint (
				new AbstractBounds(
				    new RoadwayCrownAngle(-128), 
				    new RoadwayCrownAngle(127),
				    0
				)
			    ),
			    new Bounds (
				new java.lang.Long(-128),
				new java.lang.Long(127)
			    ),
			    null
			)
		    ),
		    "laneCrownPointCenter",
		    1,
		    2
		),
		new FieldInfo (
		    new TypeInfoRef (
			new IntegerInfo (
			    new Tags (
				new short[] {
				    (short)0x8002
				}
			    ),
			    new QName (
				"org.etsi.its.codec.tool.testingtech.LibItsMapSpat_asn1.dsrc",
				"RoadwayCrownAngle"
			    ),
			    new QName (
				"DSRC",
				"RoadwayCrownAngle"
			    ),
			    12314,
			    new ValueRangeConstraint (
				new AbstractBounds(
				    new RoadwayCrownAngle(-128), 
				    new RoadwayCrownAngle(127),
				    0
				)
			    ),
			    new Bounds (
				new java.lang.Long(-128),
				new java.lang.Long(127)
			    ),
			    null
			)
		    ),
		    "laneCrownPointLeft",
		    2,
		    2
		),
		new FieldInfo (
		    new TypeInfoRef (
			new IntegerInfo (
			    new Tags (
				new short[] {
				    (short)0x8003
				}
			    ),
			    new QName (
				"org.etsi.its.codec.tool.testingtech.LibItsMapSpat_asn1.dsrc",
				"RoadwayCrownAngle"
			    ),
			    new QName (
				"DSRC",
				"RoadwayCrownAngle"
			    ),
			    12314,
			    new ValueRangeConstraint (
				new AbstractBounds(
				    new RoadwayCrownAngle(-128), 
				    new RoadwayCrownAngle(127),
				    0
				)
			    ),
			    new Bounds (
				new java.lang.Long(-128),
				new java.lang.Long(127)
			    ),
			    null
			)
		    ),
		    "laneCrownPointRight",
		    3,
		    2
		),
		new FieldInfo (
		    new TypeInfoRef (
			new IntegerInfo (
			    new Tags (
				new short[] {
				    (short)0x8004
				}
			    ),
			    new QName (
				"org.etsi.its.codec.tool.testingtech.LibItsMapSpat_asn1.dsrc",
				"MergeDivergeNodeAngle"
			    ),
			    new QName (
				"DSRC",
				"MergeDivergeNodeAngle"
			    ),
			    12314,
			    new ValueRangeConstraint (
				new AbstractBounds(
				    new MergeDivergeNodeAngle(-180), 
				    new MergeDivergeNodeAngle(180),
				    0
				)
			    ),
			    new Bounds (
				new java.lang.Long(-180),
				new java.lang.Long(180)
			    ),
			    null
			)
		    ),
		    "laneAngle",
		    4,
		    2
		),
		new FieldInfo (
		    new TypeInfoRef (
			new ContainerInfo (
			    new Tags (
				new short[] {
				    (short)0x8005
				}
			    ),
			    new QName (
				"org.etsi.its.codec.tool.testingtech.LibItsMapSpat_asn1.dsrc",
				"SpeedLimitList"
			    ),
			    new QName (
				"DSRC",
				"SpeedLimitList"
			    ),
			    12314,
			    new SizeConstraint (
				new ValueRangeConstraint (
				    new AbstractBounds(
					new com.oss.asn1.INTEGER(1), 
					new com.oss.asn1.INTEGER(9),
					0
				    )
				)
			    ),
			    new Bounds (
				new java.lang.Long(1),
				new java.lang.Long(9)
			    ),
			    new TypeInfoRef (
				new QName (
				    "org.etsi.its.codec.tool.testingtech.LibItsMapSpat_asn1.dsrc",
				    "RegulatorySpeedLimit"
				)
			    )
			)
		    ),
		    "speedLimits",
		    5,
		    2
		),
		new FieldInfo (
		    new TypeInfoRef (
			new SequenceInfo (
			    new Tags (
				new short[] {
				    (short)0x8006
				}
			    ),
			    new QName (
				"org.etsi.its.codec.tool.testingtech.LibItsMapSpat_asn1.dsrc",
				"RegionalLaneDataAttribute"
			    ),
			    new QName (
				"DSRC",
				"RegionalLaneDataAttribute"
			    ),
			    12318,
			    null,
			    new FieldsRef (
				new QName (
				    "org.etsi.its.codec.tool.testingtech.LibItsMapSpat_asn1.dsrc",
				    "RegionalLaneDataAttribute"
				)
			    ),
			    0,
			    null,
			    0
			)
		    ),
		    "regional",
		    6,
		    2
		)
	    }
	),
	0,
	new TagDecoder (
	    new TagDecoderElement[] {
		new TagDecoderElement((short)0x8000, 0),
		new TagDecoderElement((short)0x8001, 1),
		new TagDecoderElement((short)0x8002, 2),
		new TagDecoderElement((short)0x8003, 3),
		new TagDecoderElement((short)0x8004, 4),
		new TagDecoderElement((short)0x8005, 5),
		new TagDecoderElement((short)0x8006, 6)
	    }
	)
    );
    
    /**
     * Get the type descriptor (TypeInfo) of 'this' LaneDataAttribute object.
     */
    public TypeInfo getTypeInfo()
    {
	return c_typeinfo;
    }
    
    /**
     * Get the static type descriptor (TypeInfo) of 'this' LaneDataAttribute object.
     */
    public static TypeInfo getStaticTypeInfo()
    {
	return c_typeinfo;
    }
    
    /**
     * Check the current selection on unknown extension
     */
    public final boolean hasUnknownExtension()
    {
	return getChosenFlag() > 7;
    }
    
} // End class definition for LaneDataAttribute
