/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.its.pcapdump;

import java.io.File;
import java.io.IOException;
import java.util.logging.ConsoleHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.etsi.its.pcapdump.CmdLineParser;
import org.etsi.its.pcapdump.ILayer;
import org.etsi.its.pcapdump.PcapMultiplexer;

public class pcapdump
implements ILayer {
    public static final String Version = "1.0.0.0";
    private static final Logger _logger = Logger.getLogger("org.etsi.its.pcapdump");
    private static String NicAddr = "00FF6BADBFC2";
    private static String FileName = "itsdump.pcapng";
    private static Level Debug = Level.OFF;
    private static short FrameType = (short)-30393;

    @Override
    public void dispose() {
        PcapMultiplexer.getInstance().unregister(this);
    }

    public static void main(String[] args) {
        pcapdump.processCommandLine(args);
        _logger.addHandler(new ConsoleHandler());
        _logger.setLevel(Debug);
        File file = new File(FileName);
        if (file.exists()) {
            File newFile = new File(String.valueOf(FileName) + "_" + System.currentTimeMillis());
            file.renameTo(newFile);
        }
        pcapdump layer = new pcapdump();
        PcapMultiplexer.getInstance(NicAddr);
        PcapMultiplexer.getInstance().register(layer, FrameType);
        boolean bContinue = true;
        while (bContinue) {
            try {
                if (System.in.available() > 0) {
                    int token = System.in.read();
                    switch (token) {
                        case 63: 
                        case 104: {
                            pcapdump.cmdeLineUsage();
                            break;
                        }
                        case 113: {
                            bContinue = false;
                            _logger.info("Terminate application...");
                        }
                    }
                }
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        layer.dispose();
        System.err.println("Terminated");
        System.exit(0);
    }

    private static void processCommandLine(String[] args) {
        if (args.length == 0) {
            return;
        }
        CmdLineParser parser = new CmdLineParser();
        CmdLineParser.Option debug = parser.addBooleanOption("Debug");
        CmdLineParser.Option fileName = parser.addStringOption("FileName");
        CmdLineParser.Option frameType = parser.addStringOption("FrameType");
        CmdLineParser.Option NICAddr = parser.addStringOption("NicAddr");
        try {
            parser.parse(args);
        }
        catch (CmdLineParser.IllegalOptionValueException e) {
            e.printStackTrace();
            pcapdump.printUsage();
            System.exit(2);
        }
        catch (CmdLineParser.UnknownOptionException e) {
            e.printStackTrace();
            pcapdump.printUsage();
            System.exit(3);
        }
        Object value = parser.getOptionValue(debug, false);
        if (value != null) {
            Level level = Debug = (Boolean)value != false ? Level.ALL : Level.OFF;
        }
        if ((value = parser.getOptionValue(fileName, "")) != null && !((String)value).isEmpty()) {
            FileName = (String)value;
        }
        if ((value = parser.getOptionValue(frameType, "")) != null && !((String)value).isEmpty()) {
            FrameType = (short)Integer.parseInt((String)value, 16);
        }
        if ((value = parser.getOptionValue(NICAddr, "")) != null && !((String)value).isEmpty()) {
            NicAddr = (String)value;
        }
    }

    private static void printUsage() {
        System.err.println("Usage: [--Debug (default:false)]\n [--FileName=filename \"Output file name \"]\n [--FrameType=0x8947 \"Ethernet prototype\" (0x8947)]\n \n");
    }

    private static void cmdeLineUsage() {
        System.err.println("Command Line Usage: \n [q to exit]\n \n");
    }

    @Override
    public String getFileName() {
        return FileName;
    }
}

