/*
 * Decompiled with CFR 0.152.
 */
package org.etsi.its.pcapdump;

import java.io.IOException;
import java.util.ArrayList;
import org.etsi.common.ByteHelper;
import org.etsi.its.pcapdump.ILayer;
import org.jnetpcap.Pcap;
import org.jnetpcap.PcapBpfProgram;
import org.jnetpcap.PcapDumper;
import org.jnetpcap.PcapIf;
import org.jnetpcap.packet.JPacket;
import org.jnetpcap.packet.PcapPacket;
import org.jnetpcap.packet.PcapPacketHandler;

public class PcapMultiplexer
implements Runnable {
    private static String ExpectedIface = "D4BED91269BD";
    private static PcapMultiplexer instance = null;
    private StringBuilder errbuf = new StringBuilder();
    private ILayer _client;
    private PcapDumper dumper;
    private Pcap pcap;
    private Thread captureThread;
    PcapIf device;
    private String filter = "";

    private PcapMultiplexer() {
        ArrayList alldevs = new ArrayList();
        int r = Pcap.findAllDevs(alldevs, (StringBuilder)this.errbuf);
        if (r != 0 || alldevs.isEmpty()) {
            System.err.printf("Can't read list of devices, error is %s", this.errbuf.toString());
            return;
        }
        int ifaceIndex = 0;
        String expectedIface = ExpectedIface;
        while (ifaceIndex < alldevs.size()) {
            try {
                if (expectedIface.equalsIgnoreCase(ByteHelper.byteArrayToString(((PcapIf)alldevs.get(ifaceIndex)).getHardwareAddress()))) {
                    break;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            ++ifaceIndex;
        }
        if (ifaceIndex == alldevs.size()) {
            throw new RuntimeException(String.format("EthernetLayer.register: Network interface %s not found", expectedIface));
        }
        this.device = (PcapIf)alldevs.get(ifaceIndex);
        System.out.println("Listening: " + this.device.getName());
    }

    public static PcapMultiplexer getInstance(String macAddress) {
        ExpectedIface = macAddress;
        instance = new PcapMultiplexer();
        return instance;
    }

    public static PcapMultiplexer getInstance() {
        return instance;
    }

    public synchronized void register(ILayer client, short frameType) {
        int snaplen = 65536;
        int flags = 1;
        int timeout = 10;
        this.pcap = Pcap.openLive((String)this.device.getName(), (int)snaplen, (int)flags, (int)timeout, (StringBuilder)this.errbuf);
        if (this.pcap == null) {
            System.err.printf("Error while opening device for capture: " + this.errbuf.toString(), new Object[0]);
            return;
        }
        this.captureThread = new Thread(this);
        this.captureThread.start();
        this.filter = String.format("ether proto 0x%04x", frameType);
        System.out.println("New filter: " + this.filter);
        PcapBpfProgram bpfFilter = new PcapBpfProgram();
        int optimize = 0;
        int netmask = 0;
        int r = this.pcap.compile(bpfFilter, this.filter, optimize, netmask);
        if (r != 0) {
            System.out.println("Filter error: " + this.pcap.getErr());
        }
        this.pcap.setFilter(bpfFilter);
        this.dumper = this.pcap.dumpOpen(client.getFileName());
        this._client = client;
    }

    public synchronized void unregister(ILayer client) {
        this.pcap.breakloop();
        this.dumper.close();
        try {
            this.captureThread.join();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        this.pcap.close();
    }

    @Override
    public void run() {
        PcapPacketHandler<String> dumpHandler = new PcapPacketHandler<String>(){
            private int counter = 0;

            public void nextPacket(PcapPacket packet, String user) {
                PcapMultiplexer.this.dumper.dump((JPacket)packet);
                ++this.counter;
                if (this.counter == 500) {
                    System.out.println("nextPacket: Flushing file");
                    PcapMultiplexer.this.dumper.flush();
                    this.counter = 0;
                }
            }
        };
        this.pcap.loop(-1, (PcapPacketHandler)dumpHandler, (Object)"pcapdump");
    }
}

