/*
 * Decompiled with CFR 0.152.
 */
package org.jnetpcap.protocol.tcpip;

import org.jnetpcap.nio.JBuffer;
import org.jnetpcap.nio.JMemory;
import org.jnetpcap.packet.AbstractMessageHeader;
import org.jnetpcap.packet.annotate.Field;
import org.jnetpcap.packet.annotate.Header;
import org.jnetpcap.packet.annotate.ProtocolSuite;

@Header(suite=ProtocolSuite.TCP_IP)
public class Http
extends AbstractMessageHeader {
    public static final int ID = 13;

    public String contentType() {
        return this.fieldValue(Response.Content_Type);
    }

    public ContentType contentTypeEnum() {
        return ContentType.parseContentType(this.contentType());
    }

    public boolean hasChuncks() {
        return false;
    }

    public Chunk[] chunks() {
        return new Chunk[0];
    }

    protected void decodeFirstLine(String string) {
        String[] stringArray = string.split(" ");
        if (stringArray.length < 3) {
            return;
        }
        if (stringArray[0].startsWith("HTTP")) {
            super.setMessageType(AbstractMessageHeader.MessageType.RESPONSE);
            super.addField(Response.RequestVersion, stringArray[0], string.indexOf(stringArray[0]));
            super.addField(Response.ResponseCode, stringArray[1], string.indexOf(stringArray[1]));
            super.addField(Response.ResponseCodeMsg, stringArray[2], string.indexOf(stringArray[2]));
        } else {
            super.setMessageType(AbstractMessageHeader.MessageType.REQUEST);
            super.addField(Request.RequestMethod, stringArray[0], string.indexOf(stringArray[0]));
            super.addField(Request.RequestUrl, stringArray[1], string.indexOf(stringArray[1]));
            super.addField(Request.RequestVersion, stringArray[2], string.indexOf(stringArray[2]));
        }
    }

    public String fieldValue(Request request) {
        return super.fieldValue(String.class, request);
    }

    public String fieldValue(Response response) {
        return super.fieldValue(String.class, response);
    }

    public boolean hasContent() {
        return this.hasField(Response.Content_Type) || this.hasField(Request.Content_Type);
    }

    public boolean hasContentType() {
        return this.hasField(Response.Content_Type);
    }

    public boolean hasField(Request request) {
        return super.hasField(request);
    }

    public boolean hasField(Response response) {
        return super.hasField(response);
    }

    public boolean isResponse() {
        return this.getMessageType() == AbstractMessageHeader.MessageType.RESPONSE;
    }

    public String header() {
        return this.rawHeader;
    }

    public static class Chunk
    extends JBuffer {
        public Chunk(JMemory.Type type) {
            super(type);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Field
    public static enum Response {
        Accept_Ranges,
        Age,
        Allow,
        Cache_Control,
        Content_Disposition,
        Content_Encoding,
        Content_Length,
        Content_Location,
        Content_MD5,
        Content_Range,
        Content_Type,
        Expires,
        Server,
        Set_Cookie,
        RequestUrl,
        RequestVersion,
        ResponseCode,
        ResponseCodeMsg;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Field
    public static enum Request {
        Accept,
        Accept_Charset,
        Accept_Encoding,
        Accept_Ranges,
        Accept_Language,
        UA_CPU,
        Proxy_Connection,
        Authorization,
        Cache_Control,
        Connection,
        Cookie,
        Date,
        Host,
        If_Modified_Since,
        If_None_Match,
        Referer,
        RequestMethod,
        RequestUrl,
        RequestVersion,
        User_Agent,
        Content_Length,
        Content_Type;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ContentType {
        GIF("image/gif"),
        HTML("text/html"),
        JPEG("image/jpeg"),
        PNG("image/png"),
        OTHER(new String[0]);

        private final String[] magic;

        public static ContentType parseContentType(String string) {
            if (string == null) {
                return OTHER;
            }
            for (ContentType contentType : ContentType.values()) {
                if (contentType.name().equalsIgnoreCase(string)) {
                    return contentType;
                }
                for (String string2 : contentType.magic) {
                    if (!string.startsWith(string2)) continue;
                    return contentType;
                }
            }
            return OTHER;
        }

        private ContentType(String ... stringArray) {
            this.magic = stringArray;
        }
    }
}

