/*
 * Decompiled with CFR 0.152.
 */
package org.jnetpcap.protocol.sigtran;

import org.jnetpcap.nio.JBuffer;
import org.jnetpcap.packet.JHeader;
import org.jnetpcap.packet.annotate.Dynamic;
import org.jnetpcap.packet.annotate.Field;
import org.jnetpcap.packet.annotate.HeaderLength;

public abstract class SctpChunk
extends JHeader {
    public static final int DATA = 0;
    public static final int INIT = 1;
    public static final int INIT_ACK = 2;
    public static final int SACK = 3;
    public static final int HEARTBEAT = 4;
    public static final int HEARTBEAT_ACK = 5;
    public static final int ABORT = 6;
    public static final int SHUTDOWN = 7;
    public static final int SHUTDOWN_ACK = 8;
    public static final int ERROR = 9;
    public static final int COOKIE_ECHO = 10;
    public static final int COOKIE_ACK = 11;
    public static final int ECNE = 12;
    public static final int CWR = 13;
    public static final int SHUTDOWN_COMPLETE = 14;
    public static final int CHUNK_ACTION_MASK = 192;
    public static final int CHUNK_ACTION_STOP = 0;
    public static final int CHUNK_ACTION_STOP_AND_REPORT = 64;
    public static final int CHUNK_ACTION_SKIP = 128;
    public static final int CHUNK_ACTION_ERROR = 192;

    @HeaderLength
    public static int getHeaderLength(JBuffer jBuffer, int n) {
        int n2 = jBuffer.getUShort(n + 2);
        return n2 + (4 - n2 % 4) & 3;
    }

    @Field(offset=8, length=8, format="%X")
    public int flags() {
        return super.getUByte(1);
    }

    @Field(parent="flags", display="CA: if chunk not recognized", offset=6, length=2)
    public int flags_Action() {
        return (this.flags() & 0xC0) >> 6;
    }

    @Dynamic(value=Field.Property.DESCRIPTION)
    public String flags_ActionDescription() {
        switch (this.flags_Action()) {
            case 0: {
                return "stop and discard";
            }
            case 1: {
                return "stop, discard and report";
            }
            case 2: {
                return "skip and continue";
            }
            case 3: {
                return "skip, continue and report";
            }
        }
        return "unknown option";
    }

    public void flags(int n) {
        super.setUByte(1, n);
    }

    @Field(offset=16, length=16, format="%d", units="bytes")
    public int length() {
        return super.getUShort(2);
    }

    public void length(int n) {
        super.setUShort(2, n);
    }

    @Field(offset=0, length=8, format="%d")
    public int type() {
        return super.getUByte(0);
    }

    @Dynamic(value=Field.Property.DESCRIPTION)
    public String typeDescription() {
        return SctpChunkType.valueOf(this.type()).toString();
    }

    public void type(int n) {
        super.setUByte(0, n);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SctpChunkType {
        DATA,
        INIT,
        INIT_ACK,
        SACK,
        HEARTBEAT,
        HEARTBEAT_ACK,
        ABORT,
        SHUTDOWN,
        SHUTDOWN_ACK,
        ERROR,
        COOKIE_ECHO,
        COOKIE_ACK,
        ECNE,
        CWR,
        SHUTDOWN_COMPLETE;


        public static String valueOf(int n) {
            if (n < SctpChunkType.values().length) {
                return SctpChunkType.values()[n].toString();
            }
            return "Unassigned";
        }
    }
}

