/*
 * Decompiled with CFR 0.152.
 */
package org.jnetpcap.protocol.network;

import org.jnetpcap.nio.JBuffer;
import org.jnetpcap.packet.JHeaderChecksum;
import org.jnetpcap.packet.JHeaderMap;
import org.jnetpcap.packet.JSubHeader;
import org.jnetpcap.packet.annotate.Dynamic;
import org.jnetpcap.packet.annotate.Field;
import org.jnetpcap.packet.annotate.Header;
import org.jnetpcap.packet.annotate.HeaderLength;
import org.jnetpcap.util.checksum.Checksum;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Header
public class Icmp
extends JHeaderMap<Icmp>
implements JHeaderChecksum {
    public static final int ID = 12;

    @HeaderLength
    public static int headerLength(JBuffer jBuffer, int n) {
        switch (jBuffer.getUByte(n)) {
            case 0: 
            case 8: {
                return jBuffer.size() - n - 4;
            }
        }
        return 4;
    }

    @Override
    public int calculateChecksum() {
        if (this.getIndex() == -1) {
            throw new IllegalStateException("Oops index not set");
        }
        int n = this.getPreviousHeaderOffset();
        return Checksum.inChecksumShouldBe(this.checksum(), Checksum.icmp(this.packet, n, this.getOffset()));
    }

    @Override
    @Field(offset=16, length=16, format="%x")
    public int checksum() {
        return super.getUShort(2);
    }

    @Override
    public boolean checksum(int n) {
        super.setUShort(2, n);
        return true;
    }

    @Dynamic(value=Field.Property.DESCRIPTION)
    public String checksumDescription() {
        if (this.isFragmented()) {
            return "supressed for fragments";
        }
        if (this.isPayloadTruncated()) {
            return "supressed for truncated packets";
        }
        int n = this.calculateChecksum();
        if (this.checksum() == n) {
            return "correct";
        }
        return "incorrect: 0x" + Integer.toHexString(n).toUpperCase();
    }

    @Field(offset=8, length=8, format="%x")
    public int code() {
        return super.getUByte(1);
    }

    public void code(int n) {
        this.setUByte(1, n);
    }

    public IcmpCode codeEnum() {
        return IcmpCode.valueOf(this.type(), this.code());
    }

    @Override
    protected void decodeHeader() {
        int n = this.type();
        this.optionsOffsets[n] = 4;
        this.optionsBitmap = 1 << n;
        this.optionsLength[n] = this.getLength() - 4;
    }

    @Override
    public boolean isChecksumValid() {
        if (this.isFragmented()) {
            return true;
        }
        if (this.getIndex() == -1) {
            throw new IllegalStateException("Oops index not set");
        }
        int n = this.getPreviousHeaderOffset();
        return Checksum.icmp(this.packet, n, this.getOffset()) == 0;
    }

    @Override
    public boolean recalculateChecksum() {
        return this.checksum(this.calculateChecksum());
    }

    @Field(offset=0, length=8, format="%x")
    public int type() {
        return super.getUByte(0);
    }

    public void type(int n) {
        this.setUByte(0, n);
    }

    @Dynamic(value=Field.Property.DESCRIPTION)
    public String typeDescription() {
        IcmpType icmpType = IcmpType.valueOf(this.type());
        return icmpType == null ? "reserved" : icmpType.getDescription();
    }

    public IcmpType typeEnum() {
        return IcmpType.valueOf(this.type());
    }

    @Header(length=4, id=4)
    public static class SourceQuench
    extends Reserved {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class Reserved
    extends JSubHeader<Icmp> {
        public long reserved() {
            return this.getUInt(0);
        }

        public void reserved(int n) {
            this.setUInt(0, n);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Header(length=4, id=5)
    public static class Redirect
    extends JSubHeader<Icmp> {
        public byte[] gateway() {
            return this.getByteArray(0, 4);
        }

        public void gateway(byte[] byArray) {
            if (byArray.length != 4) {
                throw new IllegalArgumentException("expecting 32-bit ip4 address value");
            }
            this.setByteArray(0, byArray);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Header(length=4, id=12)
    public static class ParamProblem
    extends JSubHeader<Icmp> {
        @Field(offset=0, length=8)
        public int pointer() {
            return this.getUByte(0);
        }

        public void pointer(int n) {
            this.setUByte(0, n);
        }

        @Field(offset=8, length=24)
        public int reserved() {
            return (int)(this.getUInt(0) & 0xFFFFFFL);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum IcmpType {
        ECHO_REPLY(0, "echo reply"),
        UNASSIGNED1(1, "unassigned"),
        UNASSIGNED2(2, "unassigned"),
        DESTINATION_UNREACHABLE(3, "destination unreachable"),
        SOURCE_QUENCH(4, "source quench"),
        REDIRECT(5, "redirect"),
        ALTERNATIVE_HOST_ADDRESS(6, "Alternate Host Address"),
        UNASSIGNED7(7, "unassigned"),
        ECHO_REQUEST(8, "echo request"),
        ROUTER_ADVERTISEMENT(9, "Router Advertisement"),
        ROUTER_SELECTION(10, " Router Selection"),
        TIME_EXCEEDED(11, "time exceeded"),
        PARAM_PROBLEM(12, "parameter problem"),
        TIMESTAMP_REQUEST(13, "timestamp request"),
        TIMESTAMP_RESPONSE(14, "timestamp response"),
        INFO_REQUEST(15, "info request"),
        INFO_RESPONSE(16, "info response"),
        ADDRESS_MASK_REQUEST(17, "Address Mask Request"),
        ADDRESS_MASK_REPLY(18, "Address Mask Reply"),
        UNASSIGNED19(19, "unassigned (for security)"),
        UNASSIGNED20(20, "unassigned (for Robustness Experiment)"),
        UNASSIGNED21(21, "unassigned (for Robustness Experiment)"),
        UNASSIGNED22(22, "unassigned (for Robustness Experiment)"),
        UNASSIGNED23(23, "unassigned (for Robustness Experiment)"),
        UNASSIGNED24(24, "unassigned (for Robustness Experiment)"),
        UNASSIGNED25(25, "unassigned (for Robustness Experiment)"),
        UNASSIGNED26(26, "unassigned (for Robustness Experiment)"),
        UNASSIGNED27(27, "unassigned (for Robustness Experiment)"),
        UNASSIGNED28(28, "unassigned (for Robustness Experiment)"),
        UNASSIGNED29(29, "unassigned (for Robustness Experiment)"),
        TRACEROUTE(30, "Traceroute"),
        DATAGRAM_CONVERSION_ERROR(31, "Datagram Conversion Error"),
        MOBILE_HOST_REDIRECT(32, "Mobile Host Redirect"),
        IPV6_WHERE_ARE_YOU(33, "IPv6 Where-Are-You"),
        IPV6_I_AM_HERE(34, "IPv6 I-Am-Here"),
        MOBILE_REGISTRATION_REQUEST(35, "Mobile Registration Request"),
        MOBILE_REGISTRATION_REPLY(36, "Mobile Registration Reply"),
        DOMAIN_NAME_REQUEST(37, "Domain Name Request"),
        DOMAIN_NAME_REPLY(38, "Domain Name Reply"),
        SKIP(39, "SKIP"),
        PHOTURIS(40, "Photuris"),
        EXPERIMENTAL(41, "ICMP messages utilized by experimental mobility protocols such as Seamoby");

        public static final int DESTINATION_UNREACHABLE_ID = 3;
        public static final int ECHO_REPLY_ID = 0;
        public static final int ECHO_REQUEST_ID = 8;
        public static final int INFO_REQUEST_ID = 15;
        public static final int INFO_RESPONSE_ID = 16;
        public static final int PARAM_PROBLEM_ID = 12;
        public static final int REDIRECT_ID = 5;
        public static final int SOURCE_QUENCH_ID = 4;
        public static final int TIME_EXCEEDED_ID = 11;
        public static final int TIMESTAMP_REQUEST_ID = 13;
        public static final int TIMESTAMP_RESPONSE_ID = 14;
        private final String description;
        public final int id;

        public static String toString(int n) {
            for (IcmpType icmpType : IcmpType.values()) {
                if (icmpType.id != n) continue;
                return icmpType.description;
            }
            return null;
        }

        public static IcmpType valueOf(int n) {
            for (IcmpType icmpType : IcmpType.values()) {
                if (icmpType.id != n) continue;
                return icmpType;
            }
            return null;
        }

        private IcmpType() {
            this.id = this.ordinal();
            this.description = "reserved";
        }

        private IcmpType(int n2) {
            this.id = n2;
            this.description = this.name().toLowerCase().replace('_', ' ');
        }

        private IcmpType(int n2, String string2) {
            this.id = n2;
            this.description = string2;
        }

        public final String getDescription() {
            return this.description;
        }

        public final int getId() {
            return this.id;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum IcmpCode {
        DESTINATION_HOST_ADMIN_PROHIBITED(IcmpType.DESTINATION_UNREACHABLE, 10),
        DESTINATION_HOST_ISOLATED(IcmpType.DESTINATION_UNREACHABLE, 8),
        DESTINATION_HOST_UNKNOWN(IcmpType.DESTINATION_UNREACHABLE, 7),
        DESTINATION_HOST_UNREACHABLE_FOR_SERVICE(IcmpType.DESTINATION_UNREACHABLE, 12),
        DESTINATION_NETWORK_ADMIN_PROHIBITED(IcmpType.DESTINATION_UNREACHABLE, 9),
        DESTINATION_NETWORK_REDIRECT(IcmpType.DESTINATION_UNREACHABLE, 0),
        DESTINATION_NETWORK_UNREACHABLE(IcmpType.DESTINATION_UNREACHABLE, 6),
        DESTINATION_NETWORK_UNREACHABLE_FOR_SERVICE(IcmpType.DESTINATION_UNREACHABLE, 11),
        DESTINATION_NO_FRAG(IcmpType.DESTINATION_UNREACHABLE, 4),
        DESTINATION_PORT_UNREACHABLE(IcmpType.DESTINATION_UNREACHABLE, 3),
        DESTINATION_PROTOCOL_UNREACHABLE(IcmpType.DESTINATION_UNREACHABLE, 1),
        DESTINATION_SOURCE_ROUTE(IcmpType.DESTINATION_UNREACHABLE, 5),
        PARAMETER_PROBLEM_MISSING_OPTION(IcmpType.PARAM_PROBLEM, 1),
        PARAMETER_PROBLEM_WITH_DATAGRAM(IcmpType.PARAM_PROBLEM, 0),
        REDIRECT_HOST(IcmpType.REDIRECT, 1),
        REDIRECT_NETWORK(IcmpType.REDIRECT, 0),
        REDIRECT_SERVICE_AND_HOST(IcmpType.REDIRECT, 3),
        REDIRECT_SERVICE_AND_NETWORK(IcmpType.REDIRECT, 2),
        TIME_EXCEEDED_DURING_FRAG_REASSEMBLY(IcmpType.TIME_EXCEEDED, 1),
        TIME_EXCEEDED_IN_TRANSIT(IcmpType.TIME_EXCEEDED, 1);

        private final int code;
        private final String description;
        private final IcmpType type;

        public static String toString(int n, int n2) {
            for (IcmpCode icmpCode : IcmpCode.values()) {
                if (icmpCode.type.id != n || icmpCode.code != n2) continue;
                return icmpCode.description;
            }
            return null;
        }

        public static IcmpCode valueOf(int n, int n2) {
            for (IcmpCode icmpCode : IcmpCode.values()) {
                if (icmpCode.type.id != n || icmpCode.code != n2) continue;
                return icmpCode;
            }
            return null;
        }

        private IcmpCode(IcmpType icmpType, int n2) {
            this.type = icmpType;
            this.code = n2;
            this.description = this.name().toString().toLowerCase().replace('_', ' ');
        }

        private IcmpCode(IcmpType icmpType, int n2, String string2) {
            this.type = icmpType;
            this.code = n2;
            this.description = string2;
        }

        public final int getCode() {
            return this.code;
        }

        public final String getDescription() {
            return this.description;
        }

        public final IcmpType getType() {
            return this.type;
        }
    }

    @Header(id=8, length=4, nicname="request")
    public static class EchoRequest
    extends Echo {
    }

    @Header(id=0, length=4, nicname="reply")
    public static class EchoReply
    extends Echo {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class Echo
    extends JSubHeader<Icmp> {
        @Field(offset=0, length=16, format="%x")
        public int id() {
            return super.getUShort(0);
        }

        public void id(int n) {
            super.setUShort(0, n);
        }

        @Field(offset=16, length=16, format="%x")
        public int sequence() {
            return super.getUShort(2);
        }

        public void sequence(int n) {
            super.setUShort(2, n);
        }
    }

    @Header(length=4, id=3, nicname="unreach")
    public static class DestinationUnreachable
    extends Reserved {
    }
}

