/*
 * Decompiled with CFR 0.152.
 */
package org.jnetpcap.packet;

import java.util.ArrayList;
import org.jnetpcap.packet.JCompoundHeader;
import org.jnetpcap.packet.JHeader;
import org.jnetpcap.packet.JSubHeader;
import org.jnetpcap.packet.structure.AnnotatedHeader;
import org.jnetpcap.packet.structure.JField;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class JHeaderMap<B extends JHeader>
extends JHeader
implements JCompoundHeader<B> {
    public static final int MAX_HEADERS = 64;
    protected long optionsBitmap = -1L;
    protected int[] optionsOffsets = new int[64];
    protected int[] optionsLength = new int[64];
    protected final JHeader[] X_HEADERS = new JHeader[64];

    public JHeaderMap() {
        this.reorderAndSave(JHeaderMap.createHeaderInstances(this.annotatedHeader.getHeaders()));
    }

    private static JHeader[] createHeaderInstances(AnnotatedHeader ... annotatedHeaderArray) {
        JHeader[] jHeaderArray = new JHeader[annotatedHeaderArray.length];
        for (int i = 0; i < jHeaderArray.length; ++i) {
            jHeaderArray[i] = JHeaderMap.createHeaderInstance(annotatedHeaderArray[i]);
        }
        return jHeaderArray;
    }

    private static JHeader createHeaderInstance(AnnotatedHeader annotatedHeader) {
        try {
            return annotatedHeader.getHeaderClass().newInstance();
        }
        catch (InstantiationException instantiationException) {
            throw new IllegalStateException(instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new IllegalStateException(illegalAccessException);
        }
    }

    public JHeaderMap(int n, JField[] jFieldArray, String string, String string2, JHeader[] jHeaderArray) {
        super(n, jFieldArray, string, string2);
        this.reorderAndSave(jHeaderArray);
    }

    public JHeaderMap(int n, String string, JHeader[] jHeaderArray) {
        super(n, string);
        this.reorderAndSave(jHeaderArray);
    }

    public JHeaderMap(int n, String string, String string2, JHeader[] jHeaderArray) {
        super(n, string, string2);
        this.reorderAndSave(jHeaderArray);
    }

    @Override
    public void setSubHeaders(JHeader[] jHeaderArray) {
        this.reorderAndSave(jHeaderArray);
    }

    @Override
    public <T extends JSubHeader<B>> T getSubHeader(T t) {
        int n = this.optionsOffsets[t.getId()];
        int n2 = this.optionsLength[t.getId()];
        t.peer(this, n, n2);
        t.setOffset(n);
        t.setLength(n2);
        t.setParent(this);
        t.packet = this.packet;
        return t;
    }

    @Override
    private JHeader getSubHeader(JHeader jHeader) {
        JSubHeader jSubHeader = (JSubHeader)jHeader;
        int n = jSubHeader.getId();
        int n2 = this.optionsOffsets[n];
        int n3 = this.optionsLength[n];
        jSubHeader.peer(this, n2, n3);
        jSubHeader.setOffset(n2);
        jSubHeader.setLength(n3);
        jSubHeader.setParent(this);
        return jHeader;
    }

    @Override
    public JHeader[] getSubHeaders() {
        ArrayList<JHeader> arrayList = new ArrayList<JHeader>();
        for (int i = 0; i < 64; ++i) {
            if (!this.hasSubHeader(i) || this.X_HEADERS[i] == null) continue;
            JHeader jHeader = this.X_HEADERS[i];
            this.getSubHeader(jHeader);
            arrayList.add(this.X_HEADERS[i]);
        }
        return arrayList.toArray(new JHeader[arrayList.size()]);
    }

    @Override
    public boolean hasSubHeader(int n) {
        return (this.optionsBitmap & (long)(1 << n)) > 0L;
    }

    @Override
    public <T extends JSubHeader<B>> boolean hasSubHeader(T t) {
        if (this.hasSubHeader(t.getId())) {
            this.getSubHeader(t);
            return true;
        }
        return false;
    }

    private void reorderAndSave(JHeader[] jHeaderArray) {
        JHeader[] jHeaderArray2 = jHeaderArray;
        int n = jHeaderArray2.length;
        for (int i = 0; i < n; ++i) {
            JHeader jHeader;
            this.X_HEADERS[jHeader.getId()] = jHeader = jHeaderArray2[i];
        }
    }

    @Override
    public boolean hasSubHeaders() {
        return this.optionsBitmap != 0L;
    }

    protected void setSubHeader(int n, int n2, int n3) {
        this.optionsBitmap |= 1L << n;
        this.optionsLength[n] = n3;
        this.optionsOffsets[n] = n2;
    }
}

