/*
 * Decompiled with CFR 0.152.
 */
package com.slytechs.library;

import com.slytechs.library.Library;
import com.slytechs.library.LibraryMember;
import com.slytechs.library.NativeLibraryReference;
import com.slytechs.library.NativeSymbol;
import java.util.HashMap;
import java.util.Map;

@Library(natives={"Kernel"}, jni={"jnetpcap"})
public class NativeLibrary {
    private static final Map<String, NativeLibrary> cache = new HashMap<String, NativeLibrary>();
    protected final long address;
    private final Error error;
    public final String name;
    public final NativeLibraryReference ref;
    private final Map<String, NativeSymbol> symbols = new HashMap<String, NativeSymbol>();
    private static final Map<String, NativeSymbol> negativeSymbols = new HashMap<String, NativeSymbol>();

    @LibraryMember
    static native long dlopen(String var0);

    public static NativeLibrary loadLibrary(String string) {
        if (cache.containsKey(string)) {
            return cache.get(string);
        }
        NativeLibrary nativeLibrary = new NativeLibrary(string);
        cache.put(string, nativeLibrary);
        return nativeLibrary;
    }

    public static NativeLibrary open(String string) {
        return new NativeLibrary(string);
    }

    NativeLibrary(String string) {
        this.address = NativeLibrary.dlopen(string);
        this.error = null;
        this.ref = this.address != 0L ? new NativeLibraryReference(this, this.address) : null;
        this.name = string;
    }

    @LibraryMember
    native long dlsymbol(long var1, String var3);

    long dlsymbol(String string) {
        return this.dlsymbol(this.address, string);
    }

    public NativeSymbol getSymbol(String string) {
        if (this.symbols.containsKey(string)) {
            return this.symbols.get(string);
        }
        long l = this.dlsymbol(string);
        if (l == 0L) {
            return null;
        }
        NativeSymbol nativeSymbol = new NativeSymbol(string, l, System.mapLibraryName(this.name));
        this.symbols.put(string, nativeSymbol);
        return nativeSymbol;
    }

    public static NativeSymbol cacheSymbolNegative(String string) {
        if (negativeSymbols.containsKey(string)) {
            return negativeSymbols.get(string);
        }
        NativeSymbol nativeSymbol = new NativeSymbol(string, 0L, null);
        negativeSymbols.put(string, nativeSymbol);
        return nativeSymbol;
    }

    public boolean isLoaded() {
        return this.address != 0L;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.name).append("@0x").append(Long.toString(this.address, 16));
        return stringBuilder.toString();
    }

    public static NativeSymbol findSymbol(String string) {
        for (NativeLibrary nativeLibrary : cache.values()) {
            NativeSymbol nativeSymbol = nativeLibrary.getSymbol(string);
            if (nativeSymbol == null) continue;
            return nativeSymbol;
        }
        return NativeLibrary.cacheSymbolNegative(string);
    }
}

