/*
 * Decompiled with CFR 0.152.
 */
package com.siemens.ct.exi.datatype;

import com.siemens.ct.exi.context.DecoderContext;
import com.siemens.ct.exi.context.EncoderContext;
import com.siemens.ct.exi.context.QNameContext;
import com.siemens.ct.exi.datatype.AbstractDatatype;
import com.siemens.ct.exi.datatype.charset.XSDDateTimeCharacterSet;
import com.siemens.ct.exi.io.channel.DecoderChannel;
import com.siemens.ct.exi.io.channel.EncoderChannel;
import com.siemens.ct.exi.types.BuiltInType;
import com.siemens.ct.exi.types.DateTimeType;
import com.siemens.ct.exi.values.DateTimeValue;
import com.siemens.ct.exi.values.Value;
import java.io.IOException;
import javax.xml.namespace.QName;

public class DatetimeDatatype
extends AbstractDatatype {
    private static final long serialVersionUID = -3235729895220215225L;
    DateTimeType datetimeType;
    private DateTimeValue lastValidDatetime;

    public DatetimeDatatype(DateTimeType dateType, QName schemaType) {
        super(BuiltInType.DATETIME, schemaType);
        this.rcs = new XSDDateTimeCharacterSet();
        this.datetimeType = dateType;
    }

    public DateTimeType getDatetimeType() {
        return this.datetimeType;
    }

    protected boolean isValidString(String value) {
        this.lastValidDatetime = DateTimeValue.parse(value, this.datetimeType);
        return this.lastValidDatetime != null;
    }

    public boolean isValid(Value value) {
        if (value instanceof DateTimeValue) {
            this.lastValidDatetime = (DateTimeValue)value;
            return true;
        }
        return this.isValidString(value.toString());
    }

    public void writeValue(EncoderContext encoderContext, QNameContext qnContext, EncoderChannel valueChannel) throws IOException {
        valueChannel.encodeDateTime(this.lastValidDatetime);
    }

    public Value readValue(DecoderContext decoderContext, QNameContext qnContext, DecoderChannel valueChannel) throws IOException {
        return valueChannel.decodeDateTimeValue(this.datetimeType);
    }
}

