/*
 * Decompiled with CFR 0.152.
 */
package com.siemens.ct.exi.core;

import com.siemens.ct.exi.CodingMode;
import com.siemens.ct.exi.EXIFactory;
import com.siemens.ct.exi.context.QNameContext;
import com.siemens.ct.exi.core.AbstractEXIBodyEncoder;
import com.siemens.ct.exi.core.container.ValueAndDatatype;
import com.siemens.ct.exi.datatype.Datatype;
import com.siemens.ct.exi.exceptions.EXIException;
import com.siemens.ct.exi.io.channel.ByteEncoderChannel;
import com.siemens.ct.exi.io.channel.EncoderChannel;
import com.siemens.ct.exi.values.Value;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;

public class EXIBodyEncoderReordered
extends AbstractEXIBodyEncoder {
    protected OutputStream os;
    protected DeflaterOutputStream deflater;
    protected CodingMode codingMode;
    protected int blockValues;
    protected Value lastValue;
    protected Datatype lastDatatype;

    public EXIBodyEncoderReordered(EXIFactory exiFactory) throws EXIException {
        super(exiFactory);
        this.codingMode = exiFactory.getCodingMode();
    }

    protected void initForEachRun() throws EXIException, IOException {
        super.initForEachRun();
        this.blockValues = 0;
    }

    protected void initBlock() {
        this.blockValues = 0;
        this.encoderContext.initCompressionBlock();
    }

    public void setOutputStream(OutputStream os) throws EXIException, IOException {
        this.os = os;
        this.channel = new ByteEncoderChannel(this.getStream());
    }

    public void setOutputChannel(EncoderChannel encoderChannel) {
        this.channel = encoderChannel;
        this.os = this.channel.getOutputStream();
    }

    protected boolean isTypeValid(Datatype datatype, Value value) {
        this.lastDatatype = datatype;
        this.lastValue = value;
        return super.isTypeValid(datatype, value);
    }

    protected void writeValue(QNameContext valueContext) throws IOException {
        this.encoderContext.addValueAndDatatype(valueContext, new ValueAndDatatype(this.lastValue, this.lastDatatype));
        if (++this.blockValues == this.exiFactory.getBlockSize()) {
            this.closeBlock();
            this.initBlock();
            this.channel = new ByteEncoderChannel(this.getStream());
        }
    }

    protected OutputStream getStream() {
        if (this.codingMode == CodingMode.COMPRESSION) {
            this.deflater = new DeflaterOutputStream(this.os, new Deflater(this.codingMode.getDeflateLevel(), true));
            return this.deflater;
        }
        assert (this.codingMode == CodingMode.PRE_COMPRESSION);
        return this.os;
    }

    protected void closeBlock() throws IOException {
        if (this.channel.getLength() != 0) {
            if (this.blockValues <= 100) {
                for (QNameContext contextOrder : this.encoderContext.getChannelOrders()) {
                    List<ValueAndDatatype> lvd = this.encoderContext.getValueAndDatatypes(contextOrder);
                    for (ValueAndDatatype vd : lvd) {
                        this.typeEncoder.isValid(vd.datatype, vd.value);
                        this.typeEncoder.writeValue(this.encoderContext, contextOrder, this.channel);
                    }
                }
                this.finalizeStream();
            } else {
                List<ValueAndDatatype> lvd;
                this.finalizeStream();
                ByteEncoderChannel leq100 = new ByteEncoderChannel(this.getStream());
                boolean wasThereLeq100 = false;
                for (QNameContext contextOrder : this.encoderContext.getChannelOrders()) {
                    lvd = this.encoderContext.getValueAndDatatypes(contextOrder);
                    if (lvd.size() > 100) continue;
                    for (ValueAndDatatype vd : lvd) {
                        this.typeEncoder.isValid(vd.datatype, vd.value);
                        this.typeEncoder.writeValue(this.encoderContext, contextOrder, leq100);
                    }
                    wasThereLeq100 = true;
                }
                if (wasThereLeq100) {
                    this.finalizeStream();
                }
                for (QNameContext contextOrder : this.encoderContext.getChannelOrders()) {
                    lvd = this.encoderContext.getValueAndDatatypes(contextOrder);
                    if (lvd.size() <= 100) continue;
                    ByteEncoderChannel gre100 = new ByteEncoderChannel(this.getStream());
                    for (ValueAndDatatype vd : lvd) {
                        this.typeEncoder.isValid(vd.datatype, vd.value);
                        this.typeEncoder.writeValue(this.encoderContext, contextOrder, gre100);
                    }
                    this.finalizeStream();
                }
            }
        }
    }

    protected void finalizeStream() throws IOException {
        if (this.codingMode == CodingMode.COMPRESSION) {
            this.deflater.finish();
        }
    }

    public void flush() throws IOException {
        if (this.encoderContext != null) {
            this.closeBlock();
        }
        this.os.flush();
    }
}

