/*
 * Decompiled with CFR 0.152.
 */
package com.siemens.ct.exi.context;

import com.siemens.ct.exi.context.AbstractCoderContext;
import com.siemens.ct.exi.context.DecoderContext;
import com.siemens.ct.exi.context.EvolvingUriContext;
import com.siemens.ct.exi.context.GrammarContext;
import com.siemens.ct.exi.context.QNameContext;
import com.siemens.ct.exi.context.RuntimeQNameContextEntries;
import com.siemens.ct.exi.context.UriContext;
import com.siemens.ct.exi.core.container.PreReadValue;
import com.siemens.ct.exi.datatype.strings.StringDecoder;
import com.siemens.ct.exi.io.channel.DecoderChannel;
import com.siemens.ct.exi.util.MethodsBag;
import java.io.IOException;

public class DecoderContextImpl
extends AbstractCoderContext
implements DecoderContext {
    StringDecoder stringDecoder;

    public DecoderContextImpl(GrammarContext grammarContext, StringDecoder stringDecoder) {
        super(grammarContext);
        this.stringDecoder = stringDecoder;
    }

    public StringDecoder getStringDecoder() {
        return this.stringDecoder;
    }

    public void clear() {
        super.clear();
        this.stringDecoder.clear();
    }

    public void setPreReadValue(QNameContext qnc, PreReadValue prrReadValue) {
        RuntimeQNameContextEntries rqne = this.getRuntimeQNameContextEntries(qnc);
        rqne.preReadValue = prrReadValue;
    }

    public QNameContext decodeQName(DecoderChannel channel) throws IOException {
        return this.decodeLocalName(this.decodeUri(channel), channel);
    }

    public EvolvingUriContext decodeUri(DecoderChannel channel) throws IOException {
        EvolvingUriContext uc;
        int numberBitsUri = MethodsBag.getCodingLength(this.getNumberOfUris() + 1);
        int uriID = channel.decodeNBitUnsignedInteger(numberBitsUri);
        if (uriID == 0) {
            String uri = new String(channel.decodeString());
            uc = this.addUriContext(uri);
        } else {
            uc = this.getUriContext(--uriID);
        }
        return uc;
    }

    public QNameContext decodeLocalName(EvolvingUriContext uc, DecoderChannel channel) throws IOException {
        QNameContext qnc;
        int length = channel.decodeUnsignedInteger();
        if (length > 0) {
            String localName = new String(channel.decodeStringOnly(length - 1));
            qnc = this.addQNameContext(uc, localName);
        } else {
            int n = MethodsBag.getCodingLength(uc.getNumberOfQNames());
            int localNameID = channel.decodeNBitUnsignedInteger(n);
            qnc = uc.getQNameContext(localNameID);
        }
        return qnc;
    }

    public String decodeQNamePrefix(UriContext uc, DecoderChannel channel) throws IOException {
        String prefix = null;
        if (uc.getNamespaceUriID() == 0) {
            prefix = "";
        } else {
            int numberOfPrefixes = uc.getNumberOfPrefixes();
            if (numberOfPrefixes > 0) {
                int id = 0;
                if (numberOfPrefixes > 1) {
                    id = channel.decodeNBitUnsignedInteger(MethodsBag.getCodingLength(numberOfPrefixes));
                }
                prefix = uc.getPrefix(id);
            }
        }
        return prefix;
    }

    public String decodeNamespacePrefix(EvolvingUriContext uc, DecoderChannel channel) throws IOException {
        String prefix;
        int nPfx = MethodsBag.getCodingLength(uc.getNumberOfPrefixes() + 1);
        int pfxID = channel.decodeNBitUnsignedInteger(nPfx);
        if (pfxID == 0) {
            prefix = new String(channel.decodeString());
            uc.addPrefix(prefix);
        } else {
            prefix = uc.getPrefix(pfxID - 1);
        }
        return prefix;
    }
}

