package de.fraunhofer.sit.c2x.pki.ca.module.webserver.servlets;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Hex;
import org.apache.log4j.Logger;

import com.google.inject.Inject;

import de.fraunhofer.sit.c2x.pki.ca.core.logging.InjectLogger;
import de.fraunhofer.sit.c2x.pki.ca.module.webserver.interfaces.HtmlProvider;
import de.fraunhofer.sit.c2x.pki.ca.provider.ProviderException;
import de.fraunhofer.sit.c2x.pki.ca.provider.interfaces.AuthorizedDeviceProvider;

/**
 * 
 * @author Norbert Bissmeyer (norbert.bissmeyer@sit.fraunhofer.de)
 * 
 */
public class ItsStationReactivationServlet extends AbstractServlet {

	private static final long serialVersionUID = 1L;
	protected static final String URL = "/reactItsS";
	protected static final String TITLE = "Re-activate ITS-S";
	public static final String DATE_PATTERN_LOG = "yyyy-MM-dd HH:mm:ss";

	@InjectLogger
	private Logger logger;
	private AuthorizedDeviceProvider authorizedDeviceProvider;

	@Inject
	public ItsStationReactivationServlet(HtmlProvider htmlProvider,
			AuthorizedDeviceProvider authorizedDeviceProvider) {
		super(htmlProvider);
		this.authorizedDeviceProvider = authorizedDeviceProvider;
	}

	@Override
	public String getUrl() {
		return URL;
	}

	@Override
	public String getTitle() {
		return TITLE;
	}

	@Override
	protected String contentHtml(HttpServletRequest req, HttpServletResponse resp) {
		String userInfo = "";
		StringBuilder sb = new StringBuilder();

		// get moduleId/moduleId from GET variable
		byte[] moduleIdBytes = new byte[0];
		String moduleId = null;

		if (req.getParameter("moduleId") != null && req.getParameter("moduleId").length() > 0) {
			moduleId = req.getParameter("moduleId");
			moduleId = moduleId.trim();
			if (moduleId.length() > 0) {
				try {
					moduleIdBytes = Hex.decodeHex(moduleId.toCharArray());
					if (moduleIdBytes.length != 16) {
						moduleIdBytes = new byte[0]; // reset
						throw new Exception("The given canonical ID (" + moduleId + ") is not a valid ID!");
					}
				} catch (DecoderException e1) {
					logger.warn("Unable to decode hex values of authorized device ID " + moduleId, e1);
					userInfo = "<div id=\"errorbox\">Unable to decode hex values of authorized device ID "
							+ moduleId + "</div>";
				} catch (Exception e2) {
					logger.warn(e2.getMessage());
					userInfo = "<div id=\"errorbox\">" + e2.getMessage() + "</div>";
				}
			}
		}

		// Prepare the form
		sb.append("<form name=\"certForm\" action=\"\" method=\"get\">Re-activate ITS-S with canonical ID encoded as HEX string: ");

		if (req.getParameter("reactivate") == null) {
			// This is not a command to reactivate or delete an ITS-S

			if (moduleIdBytes.length == 16) {
				// possibly valid module id available -> insert that id in the
				// form as the suggested value
				sb.append("<input type=\"hidden\" name=\"reactivate\" value=\"true\"/>\n<input type=\"text\" id=\"moduleId\" name=\"moduleId\" value=\""
						+ moduleId
						+ "\" maxlength=\"32\" style=\"width:300px;\" />&nbsp;<input type=\"submit\" value=\"Re-activate\" /></form>");
			} else {
				sb.append("<input type=\"hidden\" name=\"reactivate\" value=\"true\"/>\n<input type=\"text\" id=\"moduleId\" name=\"moduleId\" value=\"\" maxlength=\"32\" style=\"width:300px;\" />&nbsp;<input type=\"submit\" value=\"Re-activate\" /></form>");
			}

		} else {
			// TODO reactivate and show success box

			boolean successfullyReactivated = false;
			try {
				successfullyReactivated = authorizedDeviceProvider.reactivateDevice(moduleIdBytes);
			} catch (ProviderException e) {
				logger.warn(e.getMessage());

			}
			sb.append("<input type=\"hidden\" name=\"reactivate\" value=\"true\"/>\n<input type=\"text\" id=\"moduleId\" name=\"moduleId\" value=\"\" maxlength=\"32\" style=\"width:300px;\" />&nbsp;<input type=\"submit\" value=\"Re-activate\" />");
			if (successfullyReactivated)
				sb.append("<div id=\"ackbox\">Device \"" + moduleId + "\" successfully reactivated.</div>");
			sb.append("</form>\n");
		}

		if (!userInfo.isEmpty()) {
			sb.append(userInfo);
		}

		return sb.toString();
	}

	@Override
	public boolean isProtected() {
		return true;
	}

	@Override
	public String[] getAllowedRoles() {
		return new String[] { UserRole.ADMINISTRATOR.toString(), UserRole.REGISTRATION_USER.toString(),
				UserRole.DEVELOPER.toString(), UserRole.MAINTAINER.toString() };
	}

	@Override
	public Category getCategory() {
		return Category.ITS_S;
	}
}
